/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.lucenia.indexmanagement.indexstatemanagement.SkipExecution;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.skylite.common.lifecycle.LifecycleListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginVersionSweepCoordinator
extends LifecycleListener
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PluginVersionSweepCoordinator.class);
    private final SkipExecution skipExecution;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private volatile Scheduler.Cancellable scheduledSkipExecution;
    private volatile TimeValue sweepSkipPeriod;
    private volatile boolean indexStateManagementEnabled;

    public PluginVersionSweepCoordinator(SkipExecution skipExecution, Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        this.skipExecution = skipExecution;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.sweepSkipPeriod = (TimeValue)ManagedIndexSettings.SWEEP_SKIP_PERIOD.get(settings);
        this.indexStateManagementEnabled = (Boolean)ManagedIndexSettings.INDEX_STATE_MANAGEMENT_ENABLED.get(settings);
        clusterService.addLifecycleListener((LifecycleListener)this);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.SWEEP_SKIP_PERIOD, newValue -> {
            this.sweepSkipPeriod = newValue;
            this.initBackgroundSweepISMPluginVersionExecution();
        });
    }

    public void afterStart() {
        this.initBackgroundSweepISMPluginVersionExecution();
    }

    public void beforeStop() {
        if (this.scheduledSkipExecution != null) {
            this.scheduledSkipExecution.cancel();
        }
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (event.nodesChanged() || event.isNewCluster()) {
            this.skipExecution.sweepISMPluginVersion(this.clusterService);
            this.initBackgroundSweepISMPluginVersionExecution();
        }
    }

    public void initBackgroundSweepISMPluginVersionExecution() {
        if (!this.isIndexStateManagementEnabled()) {
            return;
        }
        if (this.scheduledSkipExecution != null) {
            this.scheduledSkipExecution.cancel();
        }
        Runnable scheduledJob = () -> CompletableFuture.runAsync(() -> {
            try {
                if (!this.skipExecution.getFlag()) {
                    logger.info("Canceling sweep ism plugin version job");
                    if (this.scheduledSkipExecution != null) {
                        this.scheduledSkipExecution.cancel();
                    }
                } else {
                    this.skipExecution.sweepISMPluginVersion(this.clusterService);
                }
            }
            catch (Exception e) {
                logger.error("Failed to sweep ism plugin version", (Throwable)e);
            }
        });
        this.scheduledSkipExecution = this.threadPool.scheduleWithFixedDelay(scheduledJob, this.sweepSkipPeriod, "management");
    }

    private boolean isIndexStateManagementEnabled() {
        return this.indexStateManagementEnabled;
    }
}

