/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.skylite.Version;
import io.skylite.core.cluster.service.ClusterService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkipExecution {
    private static final Logger logger = LogManager.getLogger(SkipExecution.class);
    private volatile boolean flag = false;
    private volatile boolean hasLegacyPlugin = false;

    public boolean getFlag() {
        return this.flag;
    }

    public boolean getHasLegacyPlugin() {
        return this.hasLegacyPlugin;
    }

    public void sweepISMPluginVersion(ClusterService clusterService) {
        try {
            Version currentMinVersion = clusterService.state().nodes().getMinNodeVersion();
            Version currentMaxVersion = clusterService.state().nodes().getMaxNodeVersion();
            if (currentMinVersion != null && !currentMinVersion.equals((Object)currentMaxVersion)) {
                this.flag = true;
                logger.info("There are multiple versions of Index Management plugins in the cluster: [" + String.valueOf(currentMaxVersion) + ", " + String.valueOf(currentMinVersion) + "]");
            } else {
                this.flag = false;
            }
            if (currentMinVersion.major > Version.CURRENT.major && currentMinVersion != currentMaxVersion) {
                this.hasLegacyPlugin = true;
                logger.info("Found legacy plugin versions [" + String.valueOf(currentMinVersion) + "] and opensearch plugins versions [" + String.valueOf(currentMaxVersion) + "] in the cluster");
            } else {
                this.hasLegacyPlugin = false;
            }
        }
        catch (Exception e) {
            logger.error("Unable to fetch node versions from cluster service", (Throwable)e);
        }
    }
}

