/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.step.alias.AttemptAliasActionsStep;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesRequest;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.StepContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AliasAction
extends Action {
    public static final String name = "alias";
    public static final String ACTIONS = "actions";
    private final List<IndicesAliasesRequest.AliasActions> actions;
    private final AttemptAliasActionsStep attemptAliasActionsStep;
    private final List<Step> steps;

    public AliasAction(List<IndicesAliasesRequest.AliasActions> actions, int index) {
        super(name, index);
        if (actions == null || actions.isEmpty()) {
            throw new IllegalArgumentException("At least one alias action needs to be specified.");
        }
        List<IndicesAliasesRequest.AliasActions.Type> allowedActionTypes = Arrays.asList(IndicesAliasesRequest.AliasActions.Type.ADD, IndicesAliasesRequest.AliasActions.Type.REMOVE);
        for (IndicesAliasesRequest.AliasActions action : actions) {
            if (allowedActionTypes.contains(action.actionType())) continue;
            throw new IllegalArgumentException("Only ADD and REMOVE actions are allowed.");
        }
        for (IndicesAliasesRequest.AliasActions action : actions) {
            if (action.indices() == null || action.indices().length <= 0) continue;
            throw new IllegalArgumentException("Alias action can only work on its applied index so don't accept index/indices parameter.");
        }
        for (IndicesAliasesRequest.AliasActions action : actions) {
            if (action.aliases() != null && action.aliases().length != 0) continue;
            throw new IllegalArgumentException("At least one alias needs to be specified.");
        }
        this.actions = Collections.unmodifiableList(actions);
        this.attemptAliasActionsStep = new AttemptAliasActionsStep(this);
        this.steps = Collections.singletonList(this.attemptAliasActionsStep);
    }

    public List<IndicesAliasesRequest.AliasActions> getActions() {
        return this.actions;
    }

    public Step getStepToExecute(StepContext context) {
        return this.attemptAliasActionsStep;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getType());
        builder.field(ACTIONS, this.actions);
        builder.endObject();
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeList(this.actions);
        out.writeInt(this.getActionIndex());
    }
}

