/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.step.allocation.AttemptAllocationStep;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.StepContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AllocationAction
extends Action {
    public static final String name = "allocation";
    public static final String REQUIRE = "require";
    public static final String INCLUDE = "include";
    public static final String EXCLUDE = "exclude";
    public static final String WAIT_FOR = "wait_for";
    private final Map<String, String> require;
    private final Map<String, String> include;
    private final Map<String, String> exclude;
    private final boolean waitFor;
    private final AttemptAllocationStep attemptAllocationStep;
    private final List<Step> steps;

    public AllocationAction(Map<String, String> require, Map<String, String> include, Map<String, String> exclude, boolean waitFor, int index) {
        super(name, index);
        if (!(require != null && !require.isEmpty() || include != null && !include.isEmpty() || exclude != null && !exclude.isEmpty())) {
            throw new IllegalArgumentException("At least one allocation parameter need to be specified.");
        }
        this.require = require != null ? Collections.unmodifiableMap(require) : Collections.emptyMap();
        this.include = include != null ? Collections.unmodifiableMap(include) : Collections.emptyMap();
        this.exclude = exclude != null ? Collections.unmodifiableMap(exclude) : Collections.emptyMap();
        this.waitFor = waitFor;
        this.attemptAllocationStep = new AttemptAllocationStep(this);
        this.steps = Collections.singletonList(this.attemptAllocationStep);
    }

    public Map<String, String> getRequire() {
        return this.require;
    }

    public Map<String, String> getInclude() {
        return this.include;
    }

    public Map<String, String> getExclude() {
        return this.exclude;
    }

    public boolean getWaitFor() {
        return this.waitFor;
    }

    public Step getStepToExecute(StepContext context) {
        return this.attemptAllocationStep;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getType());
        builder.field(REQUIRE, this.require);
        builder.field(INCLUDE, this.include);
        builder.field(EXCLUDE, this.exclude);
        builder.field(WAIT_FOR, this.waitFor);
        builder.endObject();
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeMap(this.require, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMap(this.include, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMap(this.exclude, StreamOutput::writeString, StreamOutput::writeString);
        out.writeBoolean(this.waitFor);
        out.writeInt(this.getActionIndex());
    }
}

