/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.step.forcemerge.AttemptCallForceMergeStep;
import io.lucenia.indexmanagement.indexstatemanagement.step.forcemerge.AttemptSetReadOnlyStep;
import io.lucenia.indexmanagement.indexstatemanagement.step.forcemerge.WaitForForceMergeStep;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ForceMergeAction
extends Action {
    public static final String name = "force_merge";
    public static final String MAX_NUM_SEGMENTS_FIELD = "max_num_segments";
    private final int maxNumSegments;
    private final AttemptSetReadOnlyStep attemptSetReadOnlyStep;
    private final AttemptCallForceMergeStep attemptCallForceMergeStep;
    private final WaitForForceMergeStep waitForForceMergeStep;
    private final LinkedHashMap<String, Step> stepNameToStep;

    public ForceMergeAction(int maxNumSegments, int index) {
        super(name, index);
        if (maxNumSegments <= 0) {
            throw new IllegalArgumentException("Force merge max_num_segments must be greater than 0");
        }
        this.maxNumSegments = maxNumSegments;
        this.attemptSetReadOnlyStep = new AttemptSetReadOnlyStep(this);
        this.attemptCallForceMergeStep = new AttemptCallForceMergeStep(this);
        this.waitForForceMergeStep = new WaitForForceMergeStep(this);
        this.stepNameToStep = new LinkedHashMap();
        this.stepNameToStep.put("attempt_set_read_only", this.attemptSetReadOnlyStep);
        this.stepNameToStep.put("attempt_call_force_merge", this.attemptCallForceMergeStep);
        this.stepNameToStep.put("wait_for_force_merge", this.waitForForceMergeStep);
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    public Step getStepToExecute(StepContext context) {
        ManagedIndexMetaData managedIndexMetaData = context.getMetadata();
        StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
        if (stepMetaData == null) {
            return this.attemptSetReadOnlyStep;
        }
        String currentStep = stepMetaData.getName();
        if (!this.stepNameToStep.containsKey(currentStep)) {
            return this.attemptSetReadOnlyStep;
        }
        Step.StepStatus currentStepStatus = stepMetaData.getStepStatus();
        if (currentStepStatus == Step.StepStatus.COMPLETED) {
            switch (currentStep) {
                case "attempt_set_read_only": {
                    return this.attemptCallForceMergeStep;
                }
                case "attempt_call_force_merge": {
                    return this.waitForForceMergeStep;
                }
            }
            return this.stepNameToStep.get(currentStep);
        }
        return this.stepNameToStep.get(currentStep);
    }

    public List<Step> getSteps() {
        return new ArrayList<Step>(this.stepNameToStep.values());
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getType());
        builder.field(MAX_NUM_SEGMENTS_FIELD, this.maxNumSegments);
        builder.endObject();
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeInt(this.maxNumSegments);
        out.writeInt(this.getActionIndex());
    }
}

