/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.common.model.notification.Channel;
import io.lucenia.indexmanagement.indexstatemanagement.model.destination.Destination;
import io.lucenia.indexmanagement.indexstatemanagement.step.notification.AttemptNotificationStep;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.StepContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class NotificationAction
extends Action {
    public static final String name = "notification";
    public static final String DESTINATION_FIELD = "destination";
    public static final String CHANNEL_FIELD = "channel";
    public static final String MESSAGE_TEMPLATE_FIELD = "message_template";
    public static final String MUSTACHE = "mustache";
    private final Destination destination;
    private final Channel channel;
    private final Script messageTemplate;
    private final AttemptNotificationStep attemptNotificationStep;
    private final List<Step> steps;

    public NotificationAction(Destination destination, Channel channel, Script messageTemplate, int index) {
        super(name, index);
        if (destination == null && channel == null) {
            throw new IllegalArgumentException("Notification must contain a destination or channel");
        }
        if (destination != null && channel != null) {
            throw new IllegalArgumentException("Notification can only contain a single destination or channel");
        }
        if (!MUSTACHE.equals(messageTemplate.getLang())) {
            throw new IllegalArgumentException("Notification message template must be a mustache script");
        }
        this.destination = destination;
        this.channel = channel;
        this.messageTemplate = messageTemplate;
        this.attemptNotificationStep = new AttemptNotificationStep(this);
        this.steps = Collections.singletonList(this.attemptNotificationStep);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Script getMessageTemplate() {
        return this.messageTemplate;
    }

    public Step getStepToExecute(StepContext context) {
        return this.attemptNotificationStep;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getType());
        if (this.destination != null) {
            builder.field(DESTINATION_FIELD, (ToXContent)this.destination);
        }
        if (this.channel != null) {
            builder.field(CHANNEL_FIELD, (ToXContent)this.channel);
        }
        builder.field(MESSAGE_TEMPLATE_FIELD, (ToXContent)this.messageTemplate);
        builder.endObject();
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.destination);
        out.writeOptionalWriteable((Writeable)this.channel);
        this.messageTemplate.writeTo(out);
        out.writeInt(this.getActionIndex());
    }
}

