/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.step.rollover.AttemptRolloverStep;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.StepContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class RolloverAction
extends Action {
    public static final String name = "rollover";
    public static final String MIN_SIZE_FIELD = "min_size";
    public static final String MIN_DOC_COUNT_FIELD = "min_doc_count";
    public static final String MIN_INDEX_AGE_FIELD = "min_index_age";
    public static final String MIN_PRIMARY_SHARD_SIZE_FIELD = "min_primary_shard_size";
    public static final String COPY_ALIAS_FIELD = "copy_alias";
    private final ByteSizeValue minSize;
    private final Long minDocs;
    private final TimeValue minAge;
    private final ByteSizeValue minPrimaryShardSize;
    private final boolean copyAlias;
    private final AttemptRolloverStep attemptRolloverStep;
    private final List<Step> steps;

    public RolloverAction(ByteSizeValue minSize, Long minDocs, TimeValue minAge, ByteSizeValue minPrimaryShardSize, boolean copyAlias, int index) {
        super(name, index);
        if (minSize != null && minSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("RolloverAction minSize value must be greater than 0");
        }
        if (minPrimaryShardSize != null && minPrimaryShardSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("RolloverActionConfig minPrimaryShardSize value must be greater than 0");
        }
        if (minDocs != null && minDocs <= 0L) {
            throw new IllegalArgumentException("RolloverAction minDocs value must be greater than 0");
        }
        this.minSize = minSize;
        this.minDocs = minDocs;
        this.minAge = minAge;
        this.minPrimaryShardSize = minPrimaryShardSize;
        this.copyAlias = copyAlias;
        this.attemptRolloverStep = new AttemptRolloverStep(this);
        this.steps = Collections.singletonList(this.attemptRolloverStep);
    }

    public ByteSizeValue getMinSize() {
        return this.minSize;
    }

    public Long getMinDocs() {
        return this.minDocs;
    }

    public TimeValue getMinAge() {
        return this.minAge;
    }

    public ByteSizeValue getMinPrimaryShardSize() {
        return this.minPrimaryShardSize;
    }

    public boolean getCopyAlias() {
        return this.copyAlias;
    }

    public Step getStepToExecute(StepContext context) {
        return this.attemptRolloverStep;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getType());
        if (this.minSize != null) {
            builder.field(MIN_SIZE_FIELD, this.minSize.getStringRep());
        }
        if (this.minDocs != null) {
            builder.field(MIN_DOC_COUNT_FIELD, this.minDocs);
        }
        if (this.minAge != null) {
            builder.field(MIN_INDEX_AGE_FIELD, this.minAge.getStringRep());
        }
        if (this.minPrimaryShardSize != null) {
            builder.field(MIN_PRIMARY_SHARD_SIZE_FIELD, this.minPrimaryShardSize.getStringRep());
        }
        builder.field(COPY_ALIAS_FIELD, this.copyAlias);
        builder.endObject();
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.minSize);
        out.writeOptionalLong(this.minDocs);
        out.writeOptionalTimeValue(this.minAge);
        out.writeOptionalWriteable((Writeable)this.minPrimaryShardSize);
        out.writeBoolean(this.copyAlias);
        out.writeInt(this.getActionIndex());
    }
}

