/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.action.RolloverAction;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.ActionParser;
import java.io.IOException;

public class RolloverActionParser
extends ActionParser {
    public Action fromStreamInput(StreamInput sin) throws IOException {
        ByteSizeValue minSize = (ByteSizeValue)sin.readOptionalWriteable(ByteSizeValue::new);
        Long minDocs = sin.readOptionalLong();
        TimeValue minAge = sin.readOptionalTimeValue();
        ByteSizeValue minPrimaryShardSize = (ByteSizeValue)sin.readOptionalWriteable(ByteSizeValue::new);
        boolean copyAlias = sin.readBoolean();
        int index = sin.readInt();
        return new RolloverAction(minSize, minDocs, minAge, minPrimaryShardSize, copyAlias, index);
    }

    public Action fromXContent(XContentParser xcp, int index) throws IOException {
        ByteSizeValue minSize = null;
        Long minDocs = null;
        TimeValue minAge = null;
        ByteSizeValue minPrimaryShardSize = null;
        boolean copyAlias = false;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block14: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "min_size": {
                    minSize = ByteSizeValue.parseBytesSizeValue((String)xcp.text(), (String)"min_size");
                    continue block14;
                }
                case "min_doc_count": {
                    minDocs = xcp.longValue();
                    continue block14;
                }
                case "min_index_age": {
                    minAge = TimeValue.parseTimeValue((String)xcp.text(), (String)"min_index_age");
                    continue block14;
                }
                case "min_primary_shard_size": {
                    minPrimaryShardSize = ByteSizeValue.parseBytesSizeValue((String)xcp.text(), (String)"min_primary_shard_size");
                    continue block14;
                }
                case "copy_alias": {
                    copyAlias = xcp.booleanValue();
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in RolloverAction.");
        }
        return new RolloverAction(minSize, minDocs, minAge, minPrimaryShardSize, copyAlias, index);
    }

    public String getActionType() {
        return "rollover";
    }
}

