/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.AttemptMoveShardsStep;
import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.AttemptShrinkStep;
import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.WaitForMoveShardsStep;
import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.WaitForShrinkStep;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class ShrinkAction
extends Action {
    public static final String name = "shrink";
    public static final String NUM_NEW_SHARDS_FIELD = "num_new_shards";
    public static final String PERCENTAGE_OF_SOURCE_SHARDS_FIELD = "percentage_of_source_shards";
    public static final String MAX_SHARD_SIZE_FIELD = "max_shard_size";
    public static final String TARGET_INDEX_TEMPLATE_FIELD = "target_index_name_template";
    public static final String ALIASES_FIELD = "aliases";
    public static final String SWITCH_ALIASES = "switch_aliases";
    public static final String FORCE_UNSAFE_FIELD = "force_unsafe";
    public static final String LOCK_SOURCE_JOB_ID = "shrink-node_name";
    private static final String MUSTACHE = "mustache";
    private final Integer numNewShards;
    private final ByteSizeValue maxShardSize;
    private final Double percentageOfSourceShards;
    private final Script targetIndexTemplate;
    private final List<Alias> aliases;
    private final boolean switchAliases;
    private final Boolean forceUnsafe;
    private final AttemptMoveShardsStep attemptMoveShardsStep;
    private final WaitForMoveShardsStep waitForMoveShardsStep;
    private final AttemptShrinkStep attemptShrinkStep;
    private final WaitForShrinkStep waitForShrinkStep;
    private final LinkedHashMap<String, Step> stepNameToStep;

    public ShrinkAction(Integer numNewShards, ByteSizeValue maxShardSize, Double percentageOfSourceShards, Script targetIndexTemplate, List<Alias> aliases, boolean switchAliases, Boolean forceUnsafe, int index) {
        super(name, index);
        int numSet = 0;
        if (maxShardSize != null) {
            ++numSet;
        }
        if (percentageOfSourceShards != null) {
            ++numSet;
        }
        if (numNewShards != null) {
            ++numSet;
        }
        if (numSet != 1) {
            throw new IllegalArgumentException("Exactly one option specifying the number of shards to shrink to must be used.");
        }
        if (maxShardSize != null && maxShardSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("Shrink action maxShardSize must be greater than 0.");
        }
        if (percentageOfSourceShards != null && (percentageOfSourceShards <= 0.0 || percentageOfSourceShards >= 1.0)) {
            throw new IllegalArgumentException("Percentage of source shards must be between 0.0 and 1.0 exclusively");
        }
        if (numNewShards != null && numNewShards <= 0) {
            throw new IllegalArgumentException("Shrink action numNewShards must be greater than 0.");
        }
        if (targetIndexTemplate != null && !MUSTACHE.equals(targetIndexTemplate.getLang())) {
            throw new IllegalArgumentException("Target index name template must be a mustache script");
        }
        this.numNewShards = numNewShards;
        this.maxShardSize = maxShardSize;
        this.percentageOfSourceShards = percentageOfSourceShards;
        this.targetIndexTemplate = targetIndexTemplate;
        this.aliases = aliases;
        this.switchAliases = switchAliases;
        this.forceUnsafe = forceUnsafe;
        this.attemptMoveShardsStep = new AttemptMoveShardsStep(this);
        this.waitForMoveShardsStep = new WaitForMoveShardsStep(this);
        this.attemptShrinkStep = new AttemptShrinkStep(this);
        this.waitForShrinkStep = new WaitForShrinkStep(this);
        this.stepNameToStep = new LinkedHashMap();
        this.stepNameToStep.put("attempt_move_shards_step", this.attemptMoveShardsStep);
        this.stepNameToStep.put("wait_for_move_shards_step", this.waitForMoveShardsStep);
        this.stepNameToStep.put("attempt_shrink_step", this.attemptShrinkStep);
        this.stepNameToStep.put("wait_for_shrink_step", this.waitForShrinkStep);
    }

    public Integer getNumNewShards() {
        return this.numNewShards;
    }

    public ByteSizeValue getMaxShardSize() {
        return this.maxShardSize;
    }

    public Double getPercentageOfSourceShards() {
        return this.percentageOfSourceShards;
    }

    public Script getTargetIndexTemplate() {
        return this.targetIndexTemplate;
    }

    public List<Alias> getAliases() {
        return this.aliases;
    }

    public boolean getSwitchAliases() {
        return this.switchAliases;
    }

    public Boolean getForceUnsafe() {
        return this.forceUnsafe;
    }

    public List<Step> getSteps() {
        return Arrays.asList(new Step[]{this.attemptMoveShardsStep, this.waitForMoveShardsStep, this.attemptShrinkStep, this.waitForShrinkStep});
    }

    public Step getStepToExecute(StepContext context) {
        StepMetaData stepMetaData = context.getMetadata().getStepMetaData();
        if (stepMetaData == null) {
            return this.attemptMoveShardsStep;
        }
        String currentStep = stepMetaData.getName();
        if (!this.stepNameToStep.containsKey(currentStep)) {
            return this.attemptMoveShardsStep;
        }
        Step.StepStatus currentStepStatus = stepMetaData.getStepStatus();
        if (currentStepStatus == Step.StepStatus.COMPLETED) {
            switch (currentStep) {
                case "attempt_move_shards_step": {
                    return this.waitForMoveShardsStep;
                }
                case "wait_for_move_shards_step": {
                    return this.attemptShrinkStep;
                }
                case "attempt_shrink_step": {
                    return this.waitForShrinkStep;
                }
            }
            return this.attemptMoveShardsStep;
        }
        if (currentStepStatus == Step.StepStatus.FAILED) {
            return this.attemptMoveShardsStep;
        }
        switch (stepMetaData.getName()) {
            case "attempt_move_shards_step": {
                return this.attemptMoveShardsStep;
            }
            case "wait_for_move_shards_step": {
                return this.waitForMoveShardsStep;
            }
            case "attempt_shrink_step": {
                return this.attemptShrinkStep;
            }
            case "wait_for_shrink_step": {
                return this.waitForShrinkStep;
            }
        }
        return this.attemptMoveShardsStep;
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getType());
        if (this.numNewShards != null) {
            builder.field(NUM_NEW_SHARDS_FIELD, this.numNewShards);
        }
        if (this.maxShardSize != null) {
            builder.field(MAX_SHARD_SIZE_FIELD, this.maxShardSize.getStringRep());
        }
        if (this.percentageOfSourceShards != null) {
            builder.field(PERCENTAGE_OF_SOURCE_SHARDS_FIELD, this.percentageOfSourceShards);
        }
        if (this.targetIndexTemplate != null) {
            builder.field(TARGET_INDEX_TEMPLATE_FIELD, (ToXContent)this.targetIndexTemplate);
        }
        if (this.aliases != null) {
            builder.startArray(ALIASES_FIELD);
            for (Alias alias : this.aliases) {
                builder.startObject();
                alias.toXContent(builder, ToXContent.EMPTY_PARAMS);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.field(SWITCH_ALIASES, this.switchAliases);
        if (this.forceUnsafe != null) {
            builder.field(FORCE_UNSAFE_FIELD, this.forceUnsafe);
        }
        builder.endObject();
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.numNewShards);
        out.writeOptionalWriteable((Writeable)this.maxShardSize);
        out.writeOptionalDouble(this.percentageOfSourceShards);
        out.writeBoolean(this.targetIndexTemplate != null);
        if (this.targetIndexTemplate != null) {
            this.targetIndexTemplate.writeTo(out);
        }
        if (this.aliases != null) {
            out.writeBoolean(true);
            out.writeList(this.aliases);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.switchAliases);
        out.writeOptionalBoolean(this.forceUnsafe);
        out.writeInt(this.getActionIndex());
    }

    public static String getSecurityFailureMessage(String failure) {
        return "Shrink action failed because of missing permissions: " + failure;
    }
}

