/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.action.ShrinkAction;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.ActionParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ShrinkActionParser
extends ActionParser {
    public Action fromStreamInput(StreamInput sin) throws IOException {
        Integer numNewShards = sin.readOptionalInt();
        ByteSizeValue maxShardSize = (ByteSizeValue)sin.readOptionalWriteable(ByteSizeValue::new);
        Double percentageOfSourceShards = sin.readOptionalDouble();
        Script targetIndexTemplate = sin.readBoolean() ? new Script(sin) : null;
        List aliases = sin.readBoolean() ? sin.readList(Alias::new) : null;
        boolean switchAliases = sin.readBoolean();
        Boolean forceUnsafe = sin.readOptionalBoolean();
        int index = sin.readInt();
        return new ShrinkAction(numNewShards, maxShardSize, percentageOfSourceShards, targetIndexTemplate, aliases, switchAliases, forceUnsafe, index);
    }

    public Action fromXContent(XContentParser xcp, int index) throws IOException {
        Integer numNewShards = null;
        ByteSizeValue maxShardSize = null;
        Double percentageOfSourceShards = null;
        Script targetIndexTemplate = null;
        ArrayList<Alias> aliases = null;
        boolean switchAliases = false;
        Boolean forceUnsafe = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block18: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "num_new_shards": {
                    numNewShards = xcp.intValue();
                    continue block18;
                }
                case "max_shard_size": {
                    maxShardSize = ByteSizeValue.parseBytesSizeValue((String)xcp.text(), (String)"max_shard_size");
                    continue block18;
                }
                case "percentage_of_source_shards": {
                    percentageOfSourceShards = xcp.doubleValue();
                    continue block18;
                }
                case "target_index_name_template": {
                    targetIndexTemplate = Script.parse((XContentParser)xcp, (String)"mustache");
                    continue block18;
                }
                case "aliases": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block18;
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    aliases = new ArrayList<Alias>();
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        aliases.add(Alias.fromXContent((XContentParser)xcp));
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    }
                    continue block18;
                }
                case "switch_aliases": {
                    switchAliases = xcp.booleanValue();
                    continue block18;
                }
                case "force_unsafe": {
                    forceUnsafe = xcp.booleanValue();
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in ShrinkAction.");
        }
        return new ShrinkAction(numNewShards, maxShardSize, percentageOfSourceShards, targetIndexTemplate, aliases, switchAliases, forceUnsafe, index);
    }

    public String getActionType() {
        return "shrink";
    }
}

