/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.action;

import io.lucenia.indexmanagement.indexstatemanagement.step.snapshot.AttemptSnapshotStep;
import io.lucenia.indexmanagement.indexstatemanagement.step.snapshot.WaitForSnapshotStep;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SnapshotAction
extends Action {
    public static final String name = "snapshot";
    public static final String REPOSITORY_FIELD = "repository";
    public static final String SNAPSHOT_FIELD = "snapshot";
    private final String repository;
    private final String snapshot;
    private final AttemptSnapshotStep attemptSnapshotStep;
    private final WaitForSnapshotStep waitForSnapshotStep;
    private final List<Step> steps;

    public SnapshotAction(String repository, String snapshot, int index) {
        super("snapshot", index);
        this.repository = repository;
        this.snapshot = snapshot;
        this.attemptSnapshotStep = new AttemptSnapshotStep(this);
        this.waitForSnapshotStep = new WaitForSnapshotStep(this);
        this.steps = Arrays.asList(new Step[]{this.attemptSnapshotStep, this.waitForSnapshotStep});
    }

    public String getRepository() {
        return this.repository;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public Step getStepToExecute(StepContext context) {
        StepMetaData stepMetaData = context.getMetadata().getStepMetaData();
        if (stepMetaData == null) {
            return this.attemptSnapshotStep;
        }
        if (stepMetaData.getStepStatus() == Step.StepStatus.COMPLETED) {
            switch (stepMetaData.getName()) {
                case "attempt_snapshot": {
                    return this.waitForSnapshotStep;
                }
            }
            return this.attemptSnapshotStep;
        }
        switch (stepMetaData.getName()) {
            case "attempt_snapshot": {
                return this.attemptSnapshotStep;
            }
        }
        return this.waitForSnapshotStep;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getType());
        builder.field(REPOSITORY_FIELD, this.repository);
        builder.field("snapshot", this.snapshot);
        builder.endObject();
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeString(this.repository);
        out.writeString(this.snapshot);
        out.writeInt(this.getActionIndex());
    }
}

