/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.lucenia.indexmanagement.indexstatemanagement.model.StateFilter;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ChangePolicy
implements Writeable,
ToXContentObject {
    public static final String POLICY_ID_FIELD = "policy_id";
    public static final String STATE_FIELD = "state";
    public static final String INCLUDE_FIELD = "include";
    public static final String IS_SAFE_FIELD = "is_safe";
    public static final String USER_FIELD = "user";
    private final String policyID;
    private final String state;
    private final List<StateFilter> include;
    private final boolean isSafe;
    private final User user;

    public ChangePolicy(String policyID, String state, List<StateFilter> include, boolean isSafe, User user) {
        this.policyID = policyID;
        this.state = state;
        this.include = include;
        this.isSafe = isSafe;
        this.user = user;
    }

    public ChangePolicy(StreamInput sin) throws IOException {
        this.policyID = sin.readString();
        this.state = sin.readOptionalString();
        this.include = sin.readList(StateFilter::new);
        this.isSafe = sin.readBoolean();
        this.user = sin.readBoolean() ? new User(sin) : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY_ID_FIELD, this.policyID);
        builder.field(STATE_FIELD, this.state);
        builder.field(IS_SAFE_FIELD, this.isSafe);
        if (params.paramAsBoolean("with_user", true)) {
            LuceniaExtensions.optionalUserField(builder, USER_FIELD, this.user);
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.policyID);
        out.writeOptionalString(this.state);
        out.writeList(this.include);
        out.writeBoolean(this.isSafe);
        out.writeBoolean(this.user != null);
        if (this.user != null) {
            this.user.writeTo(out);
        }
    }

    public static ChangePolicy parse(XContentParser xcp) throws IOException {
        String policyID = null;
        String state = null;
        boolean isSafe = false;
        User user = null;
        ArrayList<StateFilter> include = new ArrayList<StateFilter>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block14: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "policy_id": {
                    policyID = xcp.text();
                    continue block14;
                }
                case "state": {
                    state = xcp.textOrNull();
                    continue block14;
                }
                case "include": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        include.add(StateFilter.parse(xcp));
                    }
                    continue block14;
                }
                case "is_safe": {
                    isSafe = xcp.booleanValue();
                    continue block14;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in ChangePolicy.");
        }
        if (policyID == null) {
            throw new IllegalArgumentException("ChangePolicy policy id is null");
        }
        return new ChangePolicy(policyID, state, include, isSafe, user);
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public String getState() {
        return this.state;
    }

    public List<StateFilter> getInclude() {
        return this.include;
    }

    public boolean isSafe() {
        return this.isSafe;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangePolicy that = (ChangePolicy)o;
        return this.isSafe == that.isSafe && Objects.equals(this.policyID, that.policyID) && Objects.equals(this.state, that.state) && Objects.equals(this.include, that.include) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.policyID, this.state, this.include, this.isSafe, this.user);
    }

    public String toString() {
        return "ChangePolicy{policyID='" + this.policyID + "', state='" + this.state + "', include=" + String.valueOf(this.include) + ", isSafe=" + this.isSafe + ", user=" + String.valueOf(this.user) + "}";
    }

    public static class Builder {
        private String policyID;
        private String state;
        private List<StateFilter> include;
        private boolean isSafe;
        private User user;

        public Builder(ChangePolicy changePolicy) {
            this.policyID = changePolicy.policyID;
            this.state = changePolicy.state;
            this.include = changePolicy.include;
            this.isSafe = changePolicy.isSafe;
            this.user = changePolicy.user;
        }

        public Builder isSafe(boolean isSafe) {
            this.isSafe = isSafe;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public ChangePolicy build() {
            return new ChangePolicy(this.policyID, this.state, this.include, this.isSafe, this.user);
        }
    }
}

