/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.jobs.schedule.CronSchedule;
import io.skylite.jobs.schedule.ScheduleParser;
import java.io.IOException;
import java.util.Objects;

public class Conditions
implements ToXContentObject,
Writeable {
    public static final String MIN_INDEX_AGE_FIELD = "min_index_age";
    public static final String MIN_DOC_COUNT_FIELD = "min_doc_count";
    public static final String MIN_SIZE_FIELD = "min_size";
    public static final String CRON_FIELD = "cron";
    public static final String MIN_ROLLOVER_AGE_FIELD = "min_rollover_age";
    public static final String NO_ALIAS_FIELD = "no_alias";
    public static final String MIN_STATE_AGE_FIELD = "min_state_age";
    private final TimeValue indexAge;
    private final Long docCount;
    private final ByteSizeValue size;
    private final CronSchedule cron;
    private final TimeValue rolloverAge;
    private final Boolean noAlias;
    private final TimeValue minStateAge;

    public Conditions(TimeValue indexAge, Long docCount, ByteSizeValue size, CronSchedule cron, TimeValue rolloverAge, Boolean noAlias, TimeValue minStateAge) {
        int conditionCount = 0;
        if (indexAge != null) {
            ++conditionCount;
        }
        if (docCount != null) {
            ++conditionCount;
        }
        if (size != null) {
            ++conditionCount;
        }
        if (cron != null) {
            ++conditionCount;
        }
        if (rolloverAge != null) {
            ++conditionCount;
        }
        if (noAlias != null) {
            ++conditionCount;
        }
        if (minStateAge != null) {
            ++conditionCount;
        }
        if (conditionCount != 1) {
            throw new IllegalArgumentException("Cannot provide more than one Transition condition");
        }
        if (docCount != null && docCount <= 0L) {
            throw new IllegalArgumentException("Transition doc count condition must be greater than 0");
        }
        if (size != null && size.getBytes() <= 0L) {
            throw new IllegalArgumentException("Transition size condition must be greater than 0");
        }
        this.indexAge = indexAge;
        this.docCount = docCount;
        this.size = size;
        this.cron = cron;
        this.rolloverAge = rolloverAge;
        this.noAlias = noAlias;
        this.minStateAge = minStateAge;
    }

    public Conditions(StreamInput sin) throws IOException {
        this.indexAge = sin.readOptionalTimeValue();
        this.docCount = sin.readOptionalLong();
        this.size = (ByteSizeValue)sin.readOptionalWriteable(ByteSizeValue::new);
        this.cron = (CronSchedule)sin.readOptionalWriteable(CronSchedule::new);
        this.rolloverAge = sin.readOptionalTimeValue();
        this.noAlias = sin.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0) ? sin.readOptionalBoolean() : null;
        this.minStateAge = sin.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0) ? sin.readOptionalTimeValue() : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.indexAge != null) {
            builder.field(MIN_INDEX_AGE_FIELD, this.indexAge.getStringRep());
        }
        if (this.docCount != null) {
            builder.field(MIN_DOC_COUNT_FIELD, this.docCount);
        }
        if (this.size != null) {
            builder.field(MIN_SIZE_FIELD, this.size.getStringRep());
        }
        if (this.cron != null) {
            builder.field(CRON_FIELD, (ToXContent)this.cron);
        }
        if (this.rolloverAge != null) {
            builder.field(MIN_ROLLOVER_AGE_FIELD, this.rolloverAge.getStringRep());
        }
        if (this.noAlias != null) {
            builder.field(NO_ALIAS_FIELD, this.noAlias);
        }
        if (this.minStateAge != null) {
            builder.field(MIN_STATE_AGE_FIELD, this.minStateAge.getStringRep());
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalTimeValue(this.indexAge);
        out.writeOptionalLong(this.docCount);
        out.writeOptionalWriteable((Writeable)this.size);
        out.writeOptionalWriteable((Writeable)this.cron);
        out.writeOptionalTimeValue(this.rolloverAge);
        if (out.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0)) {
            out.writeOptionalBoolean(this.noAlias);
            out.writeOptionalTimeValue(this.minStateAge);
        }
    }

    public static Conditions parse(XContentParser xcp) throws IOException {
        TimeValue indexAge = null;
        Long docCount = null;
        ByteSizeValue size = null;
        CronSchedule cron = null;
        TimeValue rolloverAge = null;
        Boolean noAlias = null;
        TimeValue minStateAge = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block18: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "min_index_age": {
                    indexAge = TimeValue.parseTimeValue((String)xcp.text(), (String)MIN_INDEX_AGE_FIELD);
                    continue block18;
                }
                case "min_doc_count": {
                    docCount = xcp.longValue();
                    continue block18;
                }
                case "min_size": {
                    size = ByteSizeValue.parseBytesSizeValue((String)xcp.text(), (String)MIN_SIZE_FIELD);
                    continue block18;
                }
                case "cron": {
                    Schedule schedule = ScheduleParser.parse((XContentParser)xcp);
                    cron = schedule instanceof CronSchedule ? (CronSchedule)schedule : null;
                    continue block18;
                }
                case "min_rollover_age": {
                    rolloverAge = TimeValue.parseTimeValue((String)xcp.text(), (String)MIN_ROLLOVER_AGE_FIELD);
                    continue block18;
                }
                case "no_alias": {
                    noAlias = xcp.booleanValue();
                    continue block18;
                }
                case "min_state_age": {
                    minStateAge = TimeValue.parseTimeValue((String)xcp.text(), (String)MIN_STATE_AGE_FIELD);
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Conditions.");
        }
        return new Conditions(indexAge, docCount, size, cron, rolloverAge, noAlias, minStateAge);
    }

    public TimeValue getIndexAge() {
        return this.indexAge;
    }

    public Long getDocCount() {
        return this.docCount;
    }

    public ByteSizeValue getSize() {
        return this.size;
    }

    public CronSchedule getCron() {
        return this.cron;
    }

    public TimeValue getRolloverAge() {
        return this.rolloverAge;
    }

    public Boolean getNoAlias() {
        return this.noAlias;
    }

    public TimeValue getMinStateAge() {
        return this.minStateAge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conditions that = (Conditions)o;
        return Objects.equals(this.indexAge, that.indexAge) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.size, that.size) && Objects.equals(this.cron, that.cron) && Objects.equals(this.rolloverAge, that.rolloverAge) && Objects.equals(this.noAlias, that.noAlias) && Objects.equals(this.minStateAge, that.minStateAge);
    }

    public int hashCode() {
        return Objects.hash(this.indexAge, this.docCount, this.size, this.cron, this.rolloverAge, this.noAlias, this.minStateAge);
    }

    public String toString() {
        return "Conditions{indexAge=" + String.valueOf(this.indexAge) + ", docCount=" + this.docCount + ", size=" + String.valueOf(this.size) + ", cron=" + String.valueOf(this.cron) + ", rolloverAge=" + String.valueOf(this.rolloverAge) + ", noAlias=" + this.noAlias + ", minStateAge=" + String.valueOf(this.minStateAge) + "}";
    }
}

