/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.lucenia.indexmanagement.common.model.notification.Channel;
import io.lucenia.indexmanagement.indexstatemanagement.model.destination.Destination;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class ErrorNotification
implements ToXContentObject,
Writeable {
    public static final String DESTINATION_FIELD = "destination";
    public static final String CHANNEL_FIELD = "channel";
    public static final String MESSAGE_TEMPLATE_FIELD = "message_template";
    public static final String MUSTACHE = "mustache";
    public static final String CHANNEL_TITLE = "Index Management-ISM-Error Notification";
    private final Destination destination;
    private final Channel channel;
    private final Script messageTemplate;

    public ErrorNotification(Destination destination, Channel channel, Script messageTemplate) {
        if (destination == null && channel == null) {
            throw new IllegalArgumentException("ErrorNotification must contain a destination or channel");
        }
        if (destination != null && channel != null) {
            throw new IllegalArgumentException("ErrorNotification can only contain a single destination or channel");
        }
        if (!MUSTACHE.equals(messageTemplate.getLang())) {
            throw new IllegalArgumentException("ErrorNotification message template must be a mustache script");
        }
        this.destination = destination;
        this.channel = channel;
        this.messageTemplate = messageTemplate;
    }

    public ErrorNotification(StreamInput sin) throws IOException {
        this.destination = (Destination)sin.readOptionalWriteable(Destination::new);
        this.channel = (Channel)sin.readOptionalWriteable(Channel::new);
        this.messageTemplate = new Script(sin);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.destination != null) {
            builder.field(DESTINATION_FIELD, (ToXContent)this.destination);
        }
        if (this.channel != null) {
            builder.field(CHANNEL_FIELD, (ToXContent)this.channel);
        }
        builder.field(MESSAGE_TEMPLATE_FIELD, (ToXContent)this.messageTemplate);
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.destination);
        out.writeOptionalWriteable((Writeable)this.channel);
        this.messageTemplate.writeTo(out);
    }

    public static ErrorNotification parse(XContentParser xcp) throws IOException {
        Destination destination = null;
        Channel channel = null;
        Script messageTemplate = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "destination": {
                    destination = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Destination.parse(xcp);
                    continue block10;
                }
                case "channel": {
                    channel = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Channel.parse(xcp);
                    continue block10;
                }
                case "message_template": {
                    messageTemplate = Script.parse((XContentParser)xcp, (String)MUSTACHE);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in ErrorNotification.");
        }
        if (messageTemplate == null) {
            throw new IllegalArgumentException("ErrorNotification message template is null");
        }
        return new ErrorNotification(destination, channel, messageTemplate);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Script getMessageTemplate() {
        return this.messageTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorNotification that = (ErrorNotification)o;
        return Objects.equals(this.destination, that.destination) && Objects.equals(this.channel, that.channel) && Objects.equals(this.messageTemplate, that.messageTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.channel, this.messageTemplate);
    }

    public String toString() {
        return "ErrorNotification{destination=" + String.valueOf(this.destination) + ", channel=" + String.valueOf(this.channel) + ", messageTemplate=" + String.valueOf(this.messageTemplate) + "}";
    }
}

