/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.PolicyRetryInfoMetaData;
import io.skylite.indexmanagement.model.StateMetaData;
import java.io.IOException;
import java.util.Objects;

public class ExplainFilter
implements ToXContentObject,
Writeable {
    public static final String FILTER_FIELD = "filter";
    public static final String POLICY_ID_FIELD = "policy_id";
    public static final String STATE_FIELD = "state";
    public static final String ACTION_FIELD = "action_type";
    public static final String FAILED_FIELD = "failed";
    private final String policyID;
    private final String state;
    private final String actionType;
    private final Boolean failed;

    public ExplainFilter(String policyID, String state, String actionType, Boolean failed) {
        this.policyID = policyID;
        this.state = state;
        this.actionType = actionType;
        this.failed = failed;
    }

    public ExplainFilter(StreamInput sin) throws IOException {
        this.policyID = sin.readOptionalString();
        this.state = sin.readOptionalString();
        this.actionType = sin.readOptionalString();
        this.failed = sin.readOptionalBoolean();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(FILTER_FIELD);
        if (this.policyID != null) {
            builder.field(POLICY_ID_FIELD, this.policyID);
        }
        if (this.state != null) {
            builder.field(STATE_FIELD, this.state);
        }
        if (this.actionType != null) {
            builder.field(ACTION_FIELD, this.actionType);
        }
        if (this.failed != null) {
            builder.field(FAILED_FIELD, this.failed);
        }
        builder.endObject();
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.policyID);
        out.writeOptionalString(this.state);
        out.writeOptionalString(this.actionType);
        out.writeOptionalBoolean(this.failed);
    }

    public boolean byMetaData(ManagedIndexMetaData metaData) {
        boolean retryFailedNotValid;
        boolean isValid = true;
        StateMetaData stateMetaData = metaData.getStateMetaData();
        if (!(this.state == null || stateMetaData != null && this.state.equals(stateMetaData.getName()))) {
            isValid = false;
        }
        ActionMetaData actionMetaData = metaData.getActionMetaData();
        if (!(this.actionType == null || actionMetaData != null && this.actionType.equals(actionMetaData.getName()))) {
            isValid = false;
        }
        PolicyRetryInfoMetaData retryInfoMetaData = metaData.getPolicyRetryInfo();
        boolean actionFailedNotValid = actionMetaData == null || !Objects.equals(actionMetaData.getFailed(), this.failed);
        boolean bl = retryFailedNotValid = retryInfoMetaData == null || !Objects.equals(retryInfoMetaData.getFailed(), this.failed);
        if (this.failed != null && actionFailedNotValid && retryFailedNotValid) {
            isValid = false;
        }
        return isValid;
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public String getState() {
        return this.state;
    }

    public String getActionType() {
        return this.actionType;
    }

    public Boolean getFailed() {
        return this.failed;
    }

    public static ExplainFilter parse(XContentParser xcp) throws IOException {
        String policyID = null;
        String state = null;
        String actionType = null;
        Boolean failed = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (!FILTER_FIELD.equals(fieldName)) continue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String filter = xcp.currentName();
                xcp.nextToken();
                switch (filter) {
                    case "policy_id": {
                        policyID = xcp.text();
                        break;
                    }
                    case "state": {
                        state = xcp.text();
                        break;
                    }
                    case "action_type": {
                        actionType = xcp.text();
                        break;
                    }
                    case "failed": {
                        failed = xcp.booleanValue();
                    }
                }
            }
        }
        return new ExplainFilter(policyID, state, actionType, failed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplainFilter that = (ExplainFilter)o;
        return Objects.equals(this.policyID, that.policyID) && Objects.equals(this.state, that.state) && Objects.equals(this.actionType, that.actionType) && Objects.equals(this.failed, that.failed);
    }

    public int hashCode() {
        return Objects.hash(this.policyID, this.state, this.actionType, this.failed);
    }

    public String toString() {
        return "ExplainFilter{policyID='" + this.policyID + "', state='" + this.state + "', actionType='" + this.actionType + "', failed=" + this.failed + "}";
    }
}

