/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ISMTemplate
implements ToXContentObject,
Writeable {
    public static final String ISM_TEMPLATE_TYPE = "ism_template";
    public static final String INDEX_PATTERN = "index_patterns";
    public static final String PRIORITY = "priority";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    private final List<String> indexPatterns;
    private final int priority;
    private final Instant lastUpdatedTime;

    public ISMTemplate(List<String> indexPatterns, int priority, Instant lastUpdatedTime) {
        if (priority < 0) {
            throw new IllegalArgumentException("Requires priority to be >= 0");
        }
        if (indexPatterns == null || indexPatterns.isEmpty()) {
            throw new IllegalArgumentException("Requires at least one index pattern");
        }
        this.indexPatterns = indexPatterns;
        this.priority = priority;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public ISMTemplate(StreamInput sin) throws IOException {
        this.indexPatterns = sin.readStringList();
        this.priority = sin.readInt();
        this.lastUpdatedTime = sin.readInstant();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_PATTERN, this.indexPatterns);
        builder.field(PRIORITY, this.priority);
        LuceniaExtensions.optionalTimeField(builder, LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime);
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indexPatterns);
        out.writeInt(this.priority);
        out.writeInstant(this.lastUpdatedTime);
    }

    public static ISMTemplate parse(XContentParser xcp) throws IOException {
        ArrayList<String> indexPatterns = new ArrayList<String>();
        int priority = 0;
        Instant lastUpdatedTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index_patterns": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        indexPatterns.add(xcp.text());
                    }
                    continue block10;
                }
                case "priority": {
                    priority = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? 0 : xcp.intValue();
                    continue block10;
                }
                case "last_updated_time": {
                    lastUpdatedTime = LuceniaExtensions.instant(xcp);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in ISMTemplate.");
        }
        return new ISMTemplate(indexPatterns, priority, lastUpdatedTime != null ? lastUpdatedTime : Instant.now());
    }

    public List<String> getIndexPatterns() {
        return this.indexPatterns;
    }

    public int getPriority() {
        return this.priority;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISMTemplate that = (ISMTemplate)o;
        return this.priority == that.priority && Objects.equals(this.indexPatterns, that.indexPatterns) && Objects.equals(this.lastUpdatedTime, that.lastUpdatedTime);
    }

    public int hashCode() {
        return Objects.hash(this.indexPatterns, this.priority, this.lastUpdatedTime);
    }

    public String toString() {
        return "ISMTemplate{indexPatterns=" + String.valueOf(this.indexPatterns) + ", priority=" + this.priority + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + "}";
    }
}

