/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.jobs.schedule.ScheduleParser;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public class ManagedIndexConfig
implements ScheduledJobParameter {
    public static final String MANAGED_INDEX_TYPE = "managed_index";
    public static final String NAME_FIELD = "name";
    public static final String ENABLED_FIELD = "enabled";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    public static final String INDEX_FIELD = "index";
    public static final String INDEX_UUID_FIELD = "index_uuid";
    public static final String POLICY_ID_FIELD = "policy_id";
    public static final String POLICY_FIELD = "policy";
    public static final String POLICY_SEQ_NO_FIELD = "policy_seq_no";
    public static final String POLICY_PRIMARY_TERM_FIELD = "policy_primary_term";
    public static final String CHANGE_POLICY_FIELD = "change_policy";
    public static final String JITTER = "jitter";
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final String jobName;
    private final String index;
    private final String indexUuid;
    private final boolean enabled;
    private final Schedule jobSchedule;
    private final Instant jobLastUpdatedTime;
    private final Instant jobEnabledTime;
    private final String policyID;
    private final Long policySeqNo;
    private final Long policyPrimaryTerm;
    private final Policy policy;
    private final ChangePolicy changePolicy;
    private final Double jobJitter;

    public ManagedIndexConfig(String id, long seqNo, long primaryTerm, String jobName, String index, String indexUuid, boolean enabled, Schedule jobSchedule, Instant jobLastUpdatedTime, Instant jobEnabledTime, String policyID, Long policySeqNo, Long policyPrimaryTerm, Policy policy, ChangePolicy changePolicy, Double jobJitter) {
        if (enabled && jobEnabledTime == null) {
            throw new IllegalArgumentException("jobEnabledTime must be present if the job is enabled");
        }
        if (!enabled && jobEnabledTime != null) {
            throw new IllegalArgumentException("jobEnabledTime must not be present if the job is disabled");
        }
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.jobName = jobName;
        this.index = index;
        this.indexUuid = indexUuid;
        this.enabled = enabled;
        this.jobSchedule = jobSchedule;
        this.jobLastUpdatedTime = jobLastUpdatedTime;
        this.jobEnabledTime = jobEnabledTime;
        this.policyID = policyID;
        this.policySeqNo = policySeqNo;
        this.policyPrimaryTerm = policyPrimaryTerm;
        this.policy = policy;
        this.changePolicy = changePolicy;
        this.jobJitter = jobJitter;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.jobName;
    }

    public Instant getEnabledTime() {
        return this.jobEnabledTime;
    }

    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    public Instant getLastUpdateTime() {
        return this.jobLastUpdatedTime;
    }

    public Long getLockDurationSeconds() {
        return 3600L;
    }

    public Double getJitter() {
        return this.jobJitter;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(MANAGED_INDEX_TYPE);
        builder.field(NAME_FIELD, this.jobName);
        builder.field(ENABLED_FIELD, this.enabled);
        builder.field(INDEX_FIELD, this.index);
        builder.field(INDEX_UUID_FIELD, this.indexUuid);
        builder.field(SCHEDULE_FIELD, (ToXContent)this.jobSchedule);
        LuceniaExtensions.optionalTimeField(builder, LAST_UPDATED_TIME_FIELD, this.jobLastUpdatedTime);
        LuceniaExtensions.optionalTimeField(builder, ENABLED_TIME_FIELD, this.jobEnabledTime);
        builder.field(POLICY_ID_FIELD, this.policyID);
        builder.field(POLICY_SEQ_NO_FIELD, this.policySeqNo);
        builder.field(POLICY_PRIMARY_TERM_FIELD, this.policyPrimaryTerm);
        builder.field(POLICY_FIELD, (ToXContent)this.policy, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITHOUT_TYPE);
        builder.field(CHANGE_POLICY_FIELD, (ToXContent)this.changePolicy);
        builder.field(JITTER, this.jobJitter);
        builder.endObject();
        return builder.endObject();
    }

    public static ManagedIndexConfig parse(XContentParser xcp) throws IOException {
        return ManagedIndexConfig.parse(xcp, "", -2L, 0L);
    }

    public static ManagedIndexConfig parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        String name = null;
        String index = null;
        String indexUuid = null;
        Schedule schedule = null;
        String policyID = null;
        Policy policy = null;
        ChangePolicy changePolicy = null;
        Instant lastUpdatedTime = null;
        Instant enabledTime = null;
        boolean enabled = true;
        Long policyPrimaryTerm = 0L;
        Long policySeqNo = -2L;
        Double jitter = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block30: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    continue block30;
                }
                case "index": {
                    index = xcp.text();
                    continue block30;
                }
                case "index_uuid": {
                    indexUuid = xcp.text();
                    continue block30;
                }
                case "enabled": {
                    enabled = xcp.booleanValue();
                    continue block30;
                }
                case "schedule": {
                    schedule = ScheduleParser.parse((XContentParser)xcp);
                    continue block30;
                }
                case "enabled_time": {
                    enabledTime = LuceniaExtensions.instant(xcp);
                    continue block30;
                }
                case "last_updated_time": {
                    lastUpdatedTime = LuceniaExtensions.instant(xcp);
                    continue block30;
                }
                case "policy_id": {
                    policyID = xcp.text();
                    continue block30;
                }
                case "policy_seq_no": {
                    policySeqNo = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    continue block30;
                }
                case "policy_primary_term": {
                    policyPrimaryTerm = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    continue block30;
                }
                case "policy": {
                    policy = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Policy.parse(xcp);
                    continue block30;
                }
                case "change_policy": {
                    changePolicy = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ChangePolicy.parse(xcp);
                    continue block30;
                }
                case "jitter": {
                    jitter = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Double.valueOf(xcp.doubleValue());
                    continue block30;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in ManagedIndexConfig.");
        }
        if (enabled && enabledTime == null) {
            enabledTime = Instant.now();
        } else if (!enabled) {
            enabledTime = null;
        }
        if (index == null) {
            throw new IllegalArgumentException("ManagedIndexConfig index is null");
        }
        if (indexUuid == null) {
            throw new IllegalArgumentException("ManagedIndexConfig index uuid is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("ManagedIndexConfig name is null");
        }
        if (schedule == null) {
            throw new IllegalArgumentException("ManagedIndexConfig schedule is null");
        }
        if (lastUpdatedTime == null) {
            throw new IllegalArgumentException("ManagedIndexConfig last updated time is null");
        }
        if (policyID == null) {
            throw new IllegalArgumentException("ManagedIndexConfig policy id is null");
        }
        if (policy == null) {
            throw new IllegalArgumentException("ManagedIndexConfig policy is null");
        }
        Policy updatedPolicy = new Policy.Builder(policy).id(policyID).seqNo(policySeqNo != null ? policySeqNo : -2L).primaryTerm(policyPrimaryTerm != null ? policyPrimaryTerm : 0L).build();
        return new ManagedIndexConfig(id, seqNo, primaryTerm, name, index, indexUuid, enabled, schedule, lastUpdatedTime, enabledTime, policyID, policySeqNo, policyPrimaryTerm, updatedPolicy, changePolicy, jitter);
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexUuid() {
        return this.indexUuid;
    }

    public Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    public Instant getJobLastUpdatedTime() {
        return this.jobLastUpdatedTime;
    }

    public Instant getJobEnabledTime() {
        return this.jobEnabledTime;
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public Long getPolicySeqNo() {
        return this.policySeqNo;
    }

    public Long getPolicyPrimaryTerm() {
        return this.policyPrimaryTerm;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public ChangePolicy getChangePolicy() {
        return this.changePolicy;
    }

    public Double getJobJitter() {
        return this.jobJitter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedIndexConfig that = (ManagedIndexConfig)o;
        return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.jobName, that.jobName) && Objects.equals(this.index, that.index) && Objects.equals(this.indexUuid, that.indexUuid) && Objects.equals(this.jobSchedule, that.jobSchedule) && Objects.equals(this.jobLastUpdatedTime, that.jobLastUpdatedTime) && Objects.equals(this.jobEnabledTime, that.jobEnabledTime) && Objects.equals(this.policyID, that.policyID) && Objects.equals(this.policySeqNo, that.policySeqNo) && Objects.equals(this.policyPrimaryTerm, that.policyPrimaryTerm) && Objects.equals(this.policy, that.policy) && Objects.equals(this.changePolicy, that.changePolicy) && Objects.equals(this.jobJitter, that.jobJitter);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.seqNo, this.primaryTerm, this.jobName, this.index, this.indexUuid, this.enabled, this.jobSchedule, this.jobLastUpdatedTime, this.jobEnabledTime, this.policyID, this.policySeqNo, this.policyPrimaryTerm, this.policy, this.changePolicy, this.jobJitter);
    }

    public String toString() {
        return "ManagedIndexConfig{id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", jobName='" + this.jobName + "', index='" + this.index + "', indexUuid='" + this.indexUuid + "', enabled=" + this.enabled + ", jobSchedule=" + String.valueOf(this.jobSchedule) + ", jobLastUpdatedTime=" + String.valueOf(this.jobLastUpdatedTime) + ", jobEnabledTime=" + String.valueOf(this.jobEnabledTime) + ", policyID='" + this.policyID + "', policySeqNo=" + this.policySeqNo + ", policyPrimaryTerm=" + this.policyPrimaryTerm + ", policy=" + String.valueOf(this.policy) + ", changePolicy=" + String.valueOf(this.changePolicy) + ", jobJitter=" + this.jobJitter + "}";
    }

    public static class Builder {
        private String id;
        private long seqNo;
        private long primaryTerm;
        private String jobName;
        private String index;
        private String indexUuid;
        private boolean enabled;
        private Schedule jobSchedule;
        private Instant jobLastUpdatedTime;
        private Instant jobEnabledTime;
        private String policyID;
        private Long policySeqNo;
        private Long policyPrimaryTerm;
        private Policy policy;
        private ChangePolicy changePolicy;
        private Double jobJitter;

        public Builder() {
        }

        public Builder(ManagedIndexConfig config) {
            this.id = config.id;
            this.seqNo = config.seqNo;
            this.primaryTerm = config.primaryTerm;
            this.jobName = config.jobName;
            this.index = config.index;
            this.indexUuid = config.indexUuid;
            this.enabled = config.enabled;
            this.jobSchedule = config.jobSchedule;
            this.jobLastUpdatedTime = config.jobLastUpdatedTime;
            this.jobEnabledTime = config.jobEnabledTime;
            this.policyID = config.policyID;
            this.policySeqNo = config.policySeqNo;
            this.policyPrimaryTerm = config.policyPrimaryTerm;
            this.policy = config.policy;
            this.changePolicy = config.changePolicy;
            this.jobJitter = config.jobJitter;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        public Builder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder indexUuid(String indexUuid) {
            this.indexUuid = indexUuid;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder jobSchedule(Schedule jobSchedule) {
            this.jobSchedule = jobSchedule;
            return this;
        }

        public Builder jobLastUpdatedTime(Instant jobLastUpdatedTime) {
            this.jobLastUpdatedTime = jobLastUpdatedTime;
            return this;
        }

        public Builder jobEnabledTime(Instant jobEnabledTime) {
            this.jobEnabledTime = jobEnabledTime;
            return this;
        }

        public Builder policyID(String policyID) {
            this.policyID = policyID;
            return this;
        }

        public Builder policySeqNo(Long policySeqNo) {
            this.policySeqNo = policySeqNo;
            return this;
        }

        public Builder policyPrimaryTerm(Long policyPrimaryTerm) {
            this.policyPrimaryTerm = policyPrimaryTerm;
            return this;
        }

        public Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public Builder changePolicy(ChangePolicy changePolicy) {
            this.changePolicy = changePolicy;
            return this;
        }

        public Builder jobJitter(Double jobJitter) {
            this.jobJitter = jobJitter;
            return this;
        }

        public ManagedIndexConfig build() {
            return new ManagedIndexConfig(this.id, this.seqNo, this.primaryTerm, this.jobName, this.index, this.indexUuid, this.enabled, this.jobSchedule, this.jobLastUpdatedTime, this.jobEnabledTime, this.policyID, this.policySeqNo, this.policyPrimaryTerm, this.policy, this.changePolicy, this.jobJitter);
        }
    }
}

