/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.lucenia.indexmanagement.indexstatemanagement.model.ErrorNotification;
import io.lucenia.indexmanagement.indexstatemanagement.model.ISMTemplate;
import io.lucenia.indexmanagement.indexstatemanagement.model.State;
import io.lucenia.indexmanagement.indexstatemanagement.model.Transition;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StateMetaData;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Policy
implements ToXContentObject,
Writeable {
    public static final String POLICY_TYPE = "policy";
    public static final String POLICY_ID_FIELD = "policy_id";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    public static final String ERROR_NOTIFICATION_FIELD = "error_notification";
    public static final String DEFAULT_STATE_FIELD = "default_state";
    public static final String STATES_FIELD = "states";
    public static final String ISM_TEMPLATE = "ism_template";
    public static final String USER_FIELD = "user";
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final String description;
    private final long schemaVersion;
    private final Instant lastUpdatedTime;
    private final ErrorNotification errorNotification;
    private final String defaultState;
    private final List<State> states;
    private final List<ISMTemplate> ismTemplate;
    private final User user;

    public Policy(String id, long seqNo, long primaryTerm, String description, long schemaVersion, Instant lastUpdatedTime, ErrorNotification errorNotification, String defaultState, List<State> states, List<ISMTemplate> ismTemplate, User user) {
        Set distinctStateNames = states.stream().map(State::getName).collect(Collectors.toSet());
        for (State state2 : states) {
            for (Transition transition : state2.getTransitions()) {
                if (distinctStateNames.contains(transition.getStateName())) continue;
                throw new IllegalArgumentException("Policy contains a transition in state=" + state2.getName() + " pointing to a nonexistent state=" + transition.getStateName());
            }
        }
        if (distinctStateNames.size() != states.size()) {
            throw new IllegalArgumentException("Policy cannot have duplicate state names");
        }
        if (states.isEmpty()) {
            throw new IllegalArgumentException("Policy must contain at least one State");
        }
        boolean hasDefaultState = states.stream().anyMatch(state -> state.getName().equals(defaultState));
        if (!hasDefaultState) {
            throw new IllegalArgumentException("Policy must have a valid default state");
        }
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.description = description;
        this.schemaVersion = schemaVersion;
        this.lastUpdatedTime = lastUpdatedTime;
        this.errorNotification = errorNotification;
        this.defaultState = defaultState;
        this.states = states;
        this.ismTemplate = ismTemplate;
        this.user = user;
    }

    public Policy(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.seqNo = sin.readLong();
        this.primaryTerm = sin.readLong();
        this.description = sin.readString();
        this.schemaVersion = sin.readLong();
        this.lastUpdatedTime = sin.readInstant();
        this.errorNotification = (ErrorNotification)sin.readOptionalWriteable(ErrorNotification::new);
        this.defaultState = sin.readString();
        this.states = sin.readList(State::new);
        this.ismTemplate = sin.readBoolean() ? sin.readList(ISMTemplate::new) : null;
        this.user = sin.readBoolean() ? new User(sin) : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(POLICY_TYPE);
        }
        builder.field(POLICY_ID_FIELD, this.id);
        builder.field(DESCRIPTION_FIELD, this.description);
        LuceniaExtensions.optionalTimeField(builder, LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime);
        builder.field(SCHEMA_VERSION_FIELD, this.schemaVersion);
        builder.field(ERROR_NOTIFICATION_FIELD, (ToXContent)this.errorNotification);
        builder.field(DEFAULT_STATE_FIELD, this.defaultState);
        builder.startArray(STATES_FIELD);
        for (State state : this.states) {
            state.toXContent(builder, params);
        }
        builder.endArray();
        LuceniaExtensions.optionalISMTemplateField(builder, ISM_TEMPLATE, this.ismTemplate);
        if (params.paramAsBoolean("with_user", true)) {
            LuceniaExtensions.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeString(this.description);
        out.writeLong(this.schemaVersion);
        out.writeInstant(this.lastUpdatedTime);
        out.writeOptionalWriteable((Writeable)this.errorNotification);
        out.writeString(this.defaultState);
        out.writeList(this.states);
        if (this.ismTemplate != null) {
            out.writeBoolean(true);
            out.writeList(this.ismTemplate);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.user != null);
        if (this.user != null) {
            this.user.writeTo(out);
        }
    }

    public List<String> getDisallowedActions(List<String> allowList) {
        HashSet<String> allowListSet = new HashSet<String>(allowList);
        ArrayList<String> disallowedActions = new ArrayList<String>();
        for (State state : this.states) {
            for (Action actionConfig : state.getActions()) {
                if (allowListSet.contains(actionConfig.getType())) continue;
                disallowedActions.add(actionConfig.getType());
            }
        }
        return disallowedActions.stream().distinct().collect(Collectors.toList());
    }

    public State getStateToExecute(ManagedIndexMetaData managedIndexMetaData) {
        if (managedIndexMetaData.getTransitionTo() != null) {
            return this.states.stream().filter(state -> state.getName().equals(managedIndexMetaData.getTransitionTo())).findFirst().orElse(null);
        }
        return this.states.stream().filter(state -> {
            StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
            return stateMetaData != null && state.getName().equals(stateMetaData.getName());
        }).findFirst().orElse(null);
    }

    public static Policy parse(XContentParser xcp) throws IOException {
        return Policy.parse(xcp, "", -2L, 0L);
    }

    public static Policy parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        String description = null;
        String defaultState = null;
        ErrorNotification errorNotification = null;
        Instant lastUpdatedTime = null;
        long schemaVersion = 1L;
        ArrayList<State> states = new ArrayList<State>();
        ArrayList<ISMTemplate> ismTemplates = null;
        User user = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block22: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "schema_version": {
                    schemaVersion = xcp.longValue();
                    continue block22;
                }
                case "last_updated_time": {
                    lastUpdatedTime = LuceniaExtensions.instant(xcp);
                    continue block22;
                }
                case "policy_id": {
                    continue block22;
                }
                case "description": {
                    description = xcp.text();
                    continue block22;
                }
                case "error_notification": {
                    errorNotification = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ErrorNotification.parse(xcp);
                    continue block22;
                }
                case "default_state": {
                    defaultState = xcp.text();
                    continue block22;
                }
                case "states": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        states.add(State.parse(xcp));
                    }
                    continue block22;
                }
                case "ism_template": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block22;
                    ismTemplates = new ArrayList<ISMTemplate>();
                    if (xcp.currentToken() == XContentParser.Token.START_ARRAY) {
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            ismTemplates.add(ISMTemplate.parse(xcp));
                        }
                        continue block22;
                    }
                    if (xcp.currentToken() == XContentParser.Token.START_OBJECT) {
                        ismTemplates.add(ISMTemplate.parse(xcp));
                        continue block22;
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    continue block22;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block22;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Policy.");
        }
        if (description == null) {
            throw new IllegalArgumentException("description is null");
        }
        if (defaultState == null) {
            throw new IllegalArgumentException("default_state is null");
        }
        return new Policy(id, seqNo, primaryTerm, description, schemaVersion, lastUpdatedTime != null ? lastUpdatedTime : Instant.now(), errorNotification, defaultState, states, ismTemplates, user);
    }

    public Policy copy(String id, long seqNo, long primaryTerm) {
        return new Policy(id, seqNo, primaryTerm, this.description, this.schemaVersion, this.lastUpdatedTime, this.errorNotification, this.defaultState, this.states, this.ismTemplate, this.user);
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getDescription() {
        return this.description;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ErrorNotification getErrorNotification() {
        return this.errorNotification;
    }

    public String getDefaultState() {
        return this.defaultState;
    }

    public List<State> getStates() {
        return this.states;
    }

    public List<ISMTemplate> getISMTemplate() {
        return this.ismTemplate;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return this.seqNo == policy.seqNo && this.primaryTerm == policy.primaryTerm && this.schemaVersion == policy.schemaVersion && Objects.equals(this.id, policy.id) && Objects.equals(this.description, policy.description) && Objects.equals(this.lastUpdatedTime, policy.lastUpdatedTime) && Objects.equals(this.errorNotification, policy.errorNotification) && Objects.equals(this.defaultState, policy.defaultState) && Objects.equals(this.states, policy.states) && Objects.equals(this.ismTemplate, policy.ismTemplate) && Objects.equals(this.user, policy.user);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.seqNo, this.primaryTerm, this.description, this.schemaVersion, this.lastUpdatedTime, this.errorNotification, this.defaultState, this.states, this.ismTemplate, this.user);
    }

    public String toString() {
        return "Policy{id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", description='" + this.description + "', schemaVersion=" + this.schemaVersion + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", errorNotification=" + String.valueOf(this.errorNotification) + ", defaultState='" + this.defaultState + "', states=" + String.valueOf(this.states) + ", ismTemplate=" + String.valueOf(this.ismTemplate) + ", user=" + String.valueOf(this.user) + "}";
    }

    public static class Builder {
        private String id;
        private long seqNo;
        private long primaryTerm;
        private String description;
        private long schemaVersion;
        private Instant lastUpdatedTime;
        private ErrorNotification errorNotification;
        private String defaultState;
        private List<State> states;
        private List<ISMTemplate> ismTemplate;
        private User user;

        public Builder(Policy policy) {
            this.id = policy.id;
            this.seqNo = policy.seqNo;
            this.primaryTerm = policy.primaryTerm;
            this.description = policy.description;
            this.schemaVersion = policy.schemaVersion;
            this.lastUpdatedTime = policy.lastUpdatedTime;
            this.errorNotification = policy.errorNotification;
            this.defaultState = policy.defaultState;
            this.states = policy.states;
            this.ismTemplate = policy.ismTemplate;
            this.user = policy.user;
        }

        public Builder schemaVersion(long schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        public Builder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        public Builder states(List<State> states) {
            this.states = states;
            return this;
        }

        public Builder defaultState(String defaultState) {
            this.defaultState = defaultState;
            return this;
        }

        public Policy build() {
            return new Policy(this.id, this.seqNo, this.primaryTerm, this.description, this.schemaVersion, this.lastUpdatedTime, this.errorNotification, this.defaultState, this.states, this.ismTemplate, this.user);
        }
    }
}

