/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.lucenia.indexmanagement.indexstatemanagement.ISMActionsParser;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.action.TransitionsAction;
import io.lucenia.indexmanagement.indexstatemanagement.model.Transition;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class State
implements ToXContentObject,
Writeable {
    public static final String NAME_FIELD = "name";
    public static final String ACTIONS_FIELD = "actions";
    public static final String TRANSITIONS_FIELD = "transitions";
    private final String name;
    private final List<Action> actions;
    private final List<Transition> transitions;

    public State(String name, List<Action> actions, List<Transition> transitions) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("State must contain a valid name");
        }
        boolean hasDelete = false;
        for (Action action : actions) {
            if (hasDelete) {
                throw new IllegalArgumentException("State=" + name + " must not contain an action after a delete action");
            }
            hasDelete = "delete".equals(action.getType()) || action.deleteIndexMetadataAfterFinish();
        }
        if (hasDelete && !transitions.isEmpty()) {
            throw new IllegalArgumentException("State=" + name + " cannot contain transitions if using delete action");
        }
        this.name = name;
        this.actions = actions;
        this.transitions = transitions;
    }

    public State(StreamInput sin) throws IOException {
        this.name = sin.readString();
        this.actions = sin.readList(input -> ISMActionsParser.getInstance().fromStreamInput(input));
        this.transitions = sin.readList(Transition::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        builder.startArray(ACTIONS_FIELD);
        for (Action action : this.actions) {
            action.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(TRANSITIONS_FIELD, (Object)this.transitions.toArray(new Transition[0]));
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeList(this.actions);
        out.writeList(this.transitions);
    }

    public Action getActionToExecute(ManagedIndexMetaData managedIndexMetaData, IndexMetadataProvider indexMetadataProvider) {
        TransitionsAction actionConfig;
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        if (managedIndexMetaData.getTransitionTo() != null || actionMetaData == null) {
            actionConfig = !this.actions.isEmpty() ? this.actions.get(0) : new TransitionsAction(this.transitions, indexMetadataProvider);
        } else if ("transition".equals(actionMetaData.getName())) {
            actionConfig = new TransitionsAction(this.transitions, indexMetadataProvider);
        } else {
            TransitionsAction action;
            Action candidate;
            int actionIndex = actionMetaData.getIndex();
            String actionName = actionMetaData.getName();
            actionConfig = null;
            if (actionIndex >= 0 && actionIndex < this.actions.size() && (candidate = this.actions.get(actionIndex)).getType().equals(actionName)) {
                actionConfig = candidate;
            }
            if (actionConfig == null) {
                return null;
            }
            StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
            if (stepMetaData != null && stepMetaData.getStepStatus() == Step.StepStatus.COMPLETED && (action = actionConfig).isLastStep(stepMetaData.getName())) {
                int nextIndex = actionMetaData.getIndex() + 1;
                actionConfig = nextIndex < this.actions.size() ? this.actions.get(nextIndex) : new TransitionsAction(this.transitions, indexMetadataProvider);
            }
        }
        return actionConfig;
    }

    public static State parse(XContentParser xcp) throws IOException {
        String name = null;
        ArrayList<Action> actions = new ArrayList<Action>();
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    continue block10;
                }
                case "actions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        actions.add(ISMActionsParser.getInstance().parse(xcp, actions.size()));
                    }
                    continue block10;
                }
                case "transitions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        transitions.add(Transition.parse(xcp));
                    }
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in State.");
        }
        if (name == null) {
            throw new IllegalArgumentException("State name is null");
        }
        return new State(name, actions, transitions);
    }

    public String getName() {
        return this.name;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return Objects.equals(this.name, state.name) && Objects.equals(this.actions, state.actions) && Objects.equals(this.transitions, state.transitions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.actions, this.transitions);
    }

    public String toString() {
        return "State{name='" + this.name + "', actions=" + String.valueOf(this.actions) + ", transitions=" + String.valueOf(this.transitions) + "}";
    }
}

