/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model;

import io.lucenia.indexmanagement.indexstatemanagement.model.Conditions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class Transition
implements ToXContentObject,
Writeable {
    public static final String STATE_NAME_FIELD = "state_name";
    public static final String CONDITIONS_FIELD = "conditions";
    private final String stateName;
    private final Conditions conditions;

    public Transition(String stateName, Conditions conditions) {
        this.stateName = stateName;
        this.conditions = conditions;
    }

    public Transition(StreamInput sin) throws IOException {
        this.stateName = sin.readString();
        this.conditions = (Conditions)sin.readOptionalWriteable(Conditions::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATE_NAME_FIELD, this.stateName);
        if (this.conditions != null) {
            builder.field(CONDITIONS_FIELD, (ToXContent)this.conditions);
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.stateName);
        out.writeOptionalWriteable((Writeable)this.conditions);
    }

    public static Transition parse(XContentParser xcp) throws IOException {
        String name = null;
        Conditions conditions = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "state_name": {
                    name = xcp.text();
                    continue block8;
                }
                case "conditions": {
                    conditions = Conditions.parse(xcp);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Transition.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Transition state name is null");
        }
        return new Transition(name, conditions);
    }

    public String getStateName() {
        return this.stateName;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transition that = (Transition)o;
        return Objects.equals(this.stateName, that.stateName) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.stateName, this.conditions);
    }

    public String toString() {
        return "Transition{stateName='" + this.stateName + "', conditions=" + String.valueOf(this.conditions) + "}";
    }
}

