/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model.coordinator;

import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class SweptManagedIndexConfig {
    private final String index;
    private final long seqNo;
    private final long primaryTerm;
    private final String uuid;
    private final String policyID;
    private final Policy policy;
    private final ChangePolicy changePolicy;

    public SweptManagedIndexConfig(String index, long seqNo, long primaryTerm, String uuid, String policyID, Policy policy, ChangePolicy changePolicy) {
        this.index = index;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.uuid = uuid;
        this.policyID = policyID;
        this.policy = policy;
        this.changePolicy = changePolicy;
    }

    public String getIndex() {
        return this.index;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public ChangePolicy getChangePolicy() {
        return this.changePolicy;
    }

    public static SweptManagedIndexConfig parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        String index = null;
        String uuid = null;
        String policyID = null;
        Policy policy = null;
        ChangePolicy changePolicy = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index": {
                    index = xcp.text();
                    break;
                }
                case "index_uuid": {
                    uuid = xcp.text();
                    break;
                }
                case "policy_id": {
                    policyID = xcp.text();
                    break;
                }
                case "policy": {
                    policy = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Policy.parse(xcp);
                    break;
                }
                case "change_policy": {
                    changePolicy = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ChangePolicy.parse(xcp);
                }
            }
        }
        if (index == null) {
            throw new IllegalArgumentException("SweptManagedIndexConfig index field is required");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("SweptManagedIndexConfig uuid field is required");
        }
        if (policyID == null) {
            throw new IllegalArgumentException("SweptManagedIndexConfig policyID field is required");
        }
        return new SweptManagedIndexConfig(index, seqNo, primaryTerm, uuid, policyID, policy, changePolicy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweptManagedIndexConfig that = (SweptManagedIndexConfig)o;
        return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && Objects.equals(this.index, that.index) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.policyID, that.policyID) && Objects.equals(this.policy, that.policy) && Objects.equals(this.changePolicy, that.changePolicy);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.seqNo, this.primaryTerm, this.uuid, this.policyID, this.policy, this.changePolicy);
    }

    public String toString() {
        return "SweptManagedIndexConfig{index='" + this.index + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", uuid='" + this.uuid + "', policyID='" + this.policyID + "', policy=" + String.valueOf(this.policy) + ", changePolicy=" + String.valueOf(this.changePolicy) + "}";
    }

    public static class Builder {
        private String index;
        private long seqNo;
        private long primaryTerm;
        private String uuid;
        private String policyID;
        private Policy policy;
        private ChangePolicy changePolicy;

        public Builder(SweptManagedIndexConfig config) {
            this.index = config.index;
            this.seqNo = config.seqNo;
            this.primaryTerm = config.primaryTerm;
            this.uuid = config.uuid;
            this.policyID = config.policyID;
            this.policy = config.policy;
            this.changePolicy = config.changePolicy;
        }

        public Builder changePolicy(ChangePolicy changePolicy) {
            this.changePolicy = changePolicy;
            return this;
        }

        public SweptManagedIndexConfig build() {
            return new SweptManagedIndexConfig(this.index, this.seqNo, this.primaryTerm, this.uuid, this.policyID, this.policy, this.changePolicy);
        }
    }
}

