/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model.destination;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CustomWebhook
implements ToXContent,
Writeable {
    public static final String URL = "url";
    public static final String TYPE = "custom_webhook";
    public static final String SCHEME_FIELD = "scheme";
    public static final String HOST_FIELD = "host";
    public static final String PORT_FIELD = "port";
    public static final String PATH_FIELD = "path";
    public static final String QUERY_PARAMS_FIELD = "query_params";
    public static final String HEADER_PARAMS_FIELD = "header_params";
    public static final String USERNAME_FIELD = "username";
    public static final String PASSWORD_FIELD = "password";
    private final String url;
    private final String scheme;
    private final String host;
    private final int port;
    private final String path;
    private final Map<String, String> queryParams;
    private final Map<String, String> headerParams;
    private final String username;
    private final String password;

    public CustomWebhook(String url, String scheme, String host, int port, String path, Map<String, String> queryParams, Map<String, String> headerParams, String username, String password) {
        if (Strings.isNullOrEmpty((String)url) && Strings.isNullOrEmpty((String)host)) {
            throw new IllegalArgumentException("Url or Host name must be provided.");
        }
        this.url = url;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.queryParams = queryParams != null ? queryParams : new HashMap();
        this.headerParams = headerParams != null ? headerParams : new HashMap();
        this.username = username;
        this.password = password;
    }

    public CustomWebhook(StreamInput sin) throws IOException {
        this.url = sin.readOptionalString();
        this.scheme = sin.readOptionalString();
        this.host = sin.readOptionalString();
        this.port = sin.readInt();
        this.path = sin.readOptionalString();
        this.queryParams = sin.readMap(StreamInput::readString, StreamInput::readString);
        this.headerParams = sin.readMap(StreamInput::readString, StreamInput::readString);
        this.username = sin.readOptionalString();
        this.password = sin.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject(TYPE).field(URL, this.url).field(SCHEME_FIELD, this.scheme).field(HOST_FIELD, this.host).field(PORT_FIELD, this.port).field(PATH_FIELD, this.path).field(QUERY_PARAMS_FIELD, this.queryParams).field(HEADER_PARAMS_FIELD, this.headerParams).field(USERNAME_FIELD, this.username).field(PASSWORD_FIELD, this.password).endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.url);
        out.writeOptionalString(this.scheme);
        out.writeOptionalString(this.host);
        out.writeInt(this.port);
        out.writeOptionalString(this.path);
        out.writeMap(this.queryParams, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMap(this.headerParams, StreamOutput::writeString, StreamOutput::writeString);
        out.writeOptionalString(this.username);
        out.writeOptionalString(this.password);
    }

    public String getUrl() {
        return this.url;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaderParams() {
        return this.headerParams;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static CustomWebhook parse(XContentParser xcp) throws IOException {
        String url = null;
        String scheme = null;
        String host = null;
        int port = -1;
        String path = null;
        Map<String, String> queryParams = new HashMap<String, String>();
        Map<String, String> headerParams = new HashMap<String, String>();
        String username = null;
        String password = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block22: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "url": {
                    url = xcp.textOrNull();
                    continue block22;
                }
                case "scheme": {
                    scheme = xcp.textOrNull();
                    continue block22;
                }
                case "host": {
                    host = xcp.textOrNull();
                    continue block22;
                }
                case "port": {
                    port = xcp.intValue();
                    continue block22;
                }
                case "path": {
                    path = xcp.textOrNull();
                    continue block22;
                }
                case "query_params": {
                    queryParams = xcp.mapStrings();
                    continue block22;
                }
                case "header_params": {
                    headerParams = xcp.mapStrings();
                    continue block22;
                }
                case "username": {
                    username = xcp.textOrNull();
                    continue block22;
                }
                case "password": {
                    password = xcp.textOrNull();
                    continue block22;
                }
            }
            throw new IllegalArgumentException("Unexpected field: " + fieldName + ", while parsing custom webhook destination");
        }
        return new CustomWebhook(url, scheme, host, port, path, queryParams, headerParams, username, password);
    }

    private static Map<String, String> suppressWarning(Map<String, ?> map) {
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomWebhook that = (CustomWebhook)o;
        return this.port == that.port && Objects.equals(this.url, that.url) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.path, that.path) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.headerParams, that.headerParams) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.scheme, this.host, this.port, this.path, this.queryParams, this.headerParams, this.username, this.password);
    }

    public String toString() {
        return "CustomWebhook{url='" + this.url + "', scheme='" + this.scheme + "', host='" + this.host + "', port=" + this.port + ", path='" + this.path + "', queryParams=" + String.valueOf(this.queryParams) + ", headerParams=" + String.valueOf(this.headerParams) + ", username='" + this.username + "', password='" + this.password + "'}";
    }
}

