/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model.destination;

import io.lucenia.indexmanagement.indexstatemanagement.model.destination.Chime;
import io.lucenia.indexmanagement.indexstatemanagement.model.destination.CustomWebhook;
import io.lucenia.indexmanagement.indexstatemanagement.model.destination.DestinationType;
import io.lucenia.indexmanagement.indexstatemanagement.model.destination.Slack;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.legacy.destination.message.LegacyBaseMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacyChimeMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacyCustomWebhookMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacySlackMessage;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class Destination
implements ToXContentObject,
Writeable {
    public static final String CHIME = "chime";
    public static final String SLACK = "slack";
    public static final String CUSTOMWEBHOOK = "custom_webhook";
    private final DestinationType type;
    private final Chime chime;
    private final Slack slack;
    private final CustomWebhook customWebhook;

    public Destination(DestinationType type, Chime chime, Slack slack, CustomWebhook customWebhook) {
        this.type = type;
        this.chime = chime;
        this.slack = slack;
        this.customWebhook = customWebhook;
    }

    public Destination(StreamInput sin) throws IOException {
        this.type = (DestinationType)sin.readEnum(DestinationType.class);
        this.chime = (Chime)sin.readOptionalWriteable(Chime::new);
        this.slack = (Slack)sin.readOptionalWriteable(Slack::new);
        this.customWebhook = (CustomWebhook)sin.readOptionalWriteable(CustomWebhook::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(this.type.getValue(), this.constructResponseForDestinationType(this.type));
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.type);
        out.writeOptionalWriteable((Writeable)this.chime);
        out.writeOptionalWriteable((Writeable)this.slack);
        out.writeOptionalWriteable((Writeable)this.customWebhook);
    }

    public DestinationType getType() {
        return this.type;
    }

    public Chime getChime() {
        return this.chime;
    }

    public Slack getSlack() {
        return this.slack;
    }

    public CustomWebhook getCustomWebhook() {
        return this.customWebhook;
    }

    public static Destination parse(XContentParser xcp) throws IOException {
        DestinationType type;
        Slack slack = null;
        Chime chime = null;
        CustomWebhook customWebhook = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "chime": {
                    chime = Chime.parse(xcp);
                    continue block10;
                }
                case "slack": {
                    slack = Slack.parse(xcp);
                    continue block10;
                }
                case "custom_webhook": {
                    customWebhook = CustomWebhook.parse(xcp);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
        }
        if (chime != null) {
            type = DestinationType.CHIME;
        } else if (slack != null) {
            type = DestinationType.SLACK;
        } else if (customWebhook != null) {
            type = DestinationType.CUSTOM_WEBHOOK;
        } else {
            throw new IllegalArgumentException("Must specify a destination type");
        }
        return new Destination(type, chime, slack, customWebhook);
    }

    public LegacyBaseMessage buildLegacyBaseMessage(String compiledSubject, String compiledMessage) throws IOException {
        return switch (this.type) {
            case DestinationType.CHIME -> {
                String chimeMessageContent = this.chime.constructMessageContent(compiledSubject, compiledMessage);
                yield new LegacyChimeMessage.Builder("chime_message").withUrl(this.chime.getUrl()).withMessage(chimeMessageContent).build();
            }
            case DestinationType.SLACK -> {
                String slackMessageContent = this.slack.constructMessageContent(compiledSubject, compiledMessage);
                yield new LegacySlackMessage.Builder("slack_message").withUrl(this.slack.getUrl()).withMessage(slackMessageContent).build();
            }
            case DestinationType.CUSTOM_WEBHOOK -> new LegacyCustomWebhookMessage.Builder(CUSTOMWEBHOOK).withUrl(this.getLegacyCustomWebhookMessageURL(this.customWebhook, compiledMessage)).withHeaderParams(this.customWebhook.getHeaderParams()).withMessage(compiledMessage).build();
            default -> throw new IllegalArgumentException("Invalid destination type: " + String.valueOf((Object)this.type));
        };
    }

    public Object constructResponseForDestinationType(DestinationType type) throws IOException {
        Object content = null;
        switch (type) {
            case CHIME: {
                Map<String, Object> chimeMap = LuceniaExtensions.convertToMap(this.chime);
                content = chimeMap != null ? chimeMap.get(type.getValue()) : null;
                break;
            }
            case SLACK: {
                Map<String, Object> slackMap = LuceniaExtensions.convertToMap(this.slack);
                content = slackMap != null ? slackMap.get(type.getValue()) : null;
                break;
            }
            case CUSTOM_WEBHOOK: {
                Map<String, Object> customWebhookMap = LuceniaExtensions.convertToMap(this.customWebhook);
                Object object = content = customWebhookMap != null ? customWebhookMap.get(type.getValue()) : null;
            }
        }
        if (content == null) {
            throw new IllegalArgumentException("Content is NULL for destination type " + type.getValue());
        }
        return content;
    }

    private String getLegacyCustomWebhookMessageURL(CustomWebhook customWebhook, String compiledMessage) {
        return new LegacyCustomWebhookMessage.Builder(CUSTOMWEBHOOK).withUrl(customWebhook.getUrl()).withScheme(customWebhook.getScheme()).withHost(customWebhook.getHost()).withPort(Integer.valueOf(customWebhook.getPort())).withPath(customWebhook.getPath()).withQueryParams(customWebhook.getQueryParams()).withMessage(compiledMessage).build().getUri().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination that = (Destination)o;
        return this.type == that.type && Objects.equals(this.chime, that.chime) && Objects.equals(this.slack, that.slack) && Objects.equals(this.customWebhook, that.customWebhook);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.chime, this.slack, this.customWebhook});
    }

    public String toString() {
        return "Destination{type=" + String.valueOf((Object)this.type) + ", chime=" + String.valueOf(this.chime) + ", slack=" + String.valueOf(this.slack) + ", customWebhook=" + String.valueOf(this.customWebhook) + "}";
    }
}

