/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.model.destination;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class Slack
implements ToXContent,
Writeable {
    public static final String URL = "url";
    public static final String TYPE = "slack";
    private final String url;

    public Slack(String url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        this.url = url;
    }

    public Slack(StreamInput sin) throws IOException {
        this.url = sin.readString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject(TYPE).field(URL, this.url).endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.url);
    }

    public String getUrl() {
        return this.url;
    }

    public static Slack parse(XContentParser xcp) throws IOException {
        String url = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (URL.equals(fieldName)) {
                url = xcp.text();
                continue;
            }
            throw new IllegalArgumentException("Unexpected field: " + fieldName + ", while parsing Slack destination");
        }
        if (url == null) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        return new Slack(url);
    }

    public String constructMessageContent(String subject, String message) {
        if (Strings.isNullOrEmpty((String)subject)) {
            return message;
        }
        return subject + " \n\n " + message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slack slack = (Slack)o;
        return Objects.equals(this.url, slack.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public String toString() {
        return "Slack{url='" + this.url + "'}";
    }
}

