/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.opensearchapi;

import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.settings.LegacyOpenDistroManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.skylite.core.action.admin.indices.rollover.RolloverInfo;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ISMIndexMetadataExtensions {
    private ISMIndexMetadataExtensions() {
    }

    public static String getRolloverAlias(IndexMetadata indexMetadata) {
        String rolloverAlias = indexMetadata.getSettings().get(ManagedIndexSettings.ROLLOVER_ALIAS.getKey());
        if ((rolloverAlias == null || rolloverAlias.isBlank()) && ((rolloverAlias = indexMetadata.getSettings().get(LegacyOpenDistroManagedIndexSettings.ROLLOVER_ALIAS.getKey())) == null || rolloverAlias.isBlank())) {
            return null;
        }
        return rolloverAlias;
    }

    public static boolean getRolloverSkip(IndexMetadata indexMetadata) {
        String rolloverSkip = indexMetadata.getSettings().get(ManagedIndexSettings.ROLLOVER_SKIP.getKey());
        if (rolloverSkip == null || rolloverSkip.isBlank()) {
            return indexMetadata.getSettings().getAsBoolean(LegacyOpenDistroManagedIndexSettings.ROLLOVER_SKIP.getKey(), Boolean.valueOf(false));
        }
        return indexMetadata.getSettings().getAsBoolean(ManagedIndexSettings.ROLLOVER_SKIP.getKey(), Boolean.valueOf(false));
    }

    public static List<String> getUuidsForClosedIndices(ClusterState state, DefaultIndexMetadataService defaultIndexMetadataService) {
        ArrayList<String> closeList = new ArrayList<String>();
        Map indexMetadatas = state.metadata().indices();
        for (Map.Entry entry : indexMetadatas.entrySet()) {
            if (((IndexMetadata)entry.getValue()).getState() != IndexMetadata.State.CLOSE) continue;
            closeList.add(defaultIndexMetadataService.getIndexUUID((IndexMetadata)entry.getValue()));
        }
        return closeList;
    }

    public static <K, V> Map<K, V> filterNotNullValues(Map<K, V> map) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static MultiGetRequest buildMgetMetadataRequest(List<String> indexUuids) {
        MultiGetRequest mgetMetadataRequest = new MultiGetRequest();
        for (String indexUuid : indexUuids) {
            mgetMetadataRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(indexUuid)).routing(indexUuid));
        }
        return mgetMetadataRequest;
    }

    public static Map<String, Pair<ManagedIndexMetaData, Exception>> mgetResponseToMap(MultiGetResponse mgetResponse) {
        HashMap<String, Pair<ManagedIndexMetaData, Exception>> mgetMap = new HashMap<String, Pair<ManagedIndexMetaData, Exception>>();
        for (MultiGetItemResponse item : mgetResponse.getResponses()) {
            if (item.isFailed()) {
                mgetMap.put(item.getId(), new Pair<Object, Exception>(null, item.getFailure().getFailure()));
                continue;
            }
            if (item.getResponse() != null && !item.getResponse().isSourceEmpty()) {
                try {
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)item.getResponse().getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
                    ManagedIndexMetaData metadata = ManagedIndexMetaData.parseWithType((XContentParser)xcp, (String)item.getResponse().getId(), (long)item.getResponse().getSeqNo(), (long)item.getResponse().getPrimaryTerm());
                    mgetMap.put(item.getId(), new Pair<ManagedIndexMetaData, Object>(metadata, null));
                }
                catch (IOException e) {
                    mgetMap.put(item.getId(), new Pair<Object, IOException>(null, e));
                }
                continue;
            }
            mgetMap.put(item.getId(), new Pair<Object, Object>(null, null));
        }
        return mgetMap;
    }

    public static Instant getOldestRolloverTime(IndexMetadata indexMetadata) {
        if (indexMetadata.getRolloverInfos() == null || indexMetadata.getRolloverInfos().isEmpty()) {
            return null;
        }
        Long minTime = null;
        for (RolloverInfo rolloverInfo : indexMetadata.getRolloverInfos().values()) {
            if (minTime != null && rolloverInfo.getTime() >= minTime) continue;
            minTime = rolloverInfo.getTime();
        }
        return minTime != null ? Instant.ofEpochMilli(minTime) : null;
    }

    public static XContentBuilder addObject(XContentBuilder builder, String name, ToXContentFragment metadata, ToXContent.Params params, boolean forIndex) throws IOException {
        if (metadata != null) {
            return ISMIndexMetadataExtensions.buildMetadata(builder, name, metadata, params);
        }
        return forIndex ? builder.nullField(name) : builder;
    }

    public static XContentBuilder addObject(XContentBuilder builder, String name, ToXContentFragment metadata, ToXContent.Params params) throws IOException {
        return ISMIndexMetadataExtensions.addObject(builder, name, metadata, params, false);
    }

    public static XContentBuilder buildMetadata(XContentBuilder builder, String name, ToXContentFragment metadata, ToXContent.Params params) throws IOException {
        builder.startObject(name);
        metadata.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static class Pair<F, S> {
        private final F first;
        private final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }
}

