/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.resthandler;

import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.changepolicy.ChangePolicyAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.changepolicy.ChangePolicyRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestChangePolicyAction
extends BaseRestHandler {
    public static final String CHANGE_POLICY_BASE_URI = "/_plugins/_ism/change_policy";
    public static final String LEGACY_CHANGE_POLICY_BASE_URI = "/_opendistro/_ism/change_policy";
    public static final String INDEX_NOT_MANAGED = "This index is not being managed";
    public static final String INDEX_IN_TRANSITION = "Cannot change policy while transitioning to new state";

    public List<RestHandler.Route> routes() {
        return List.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, CHANGE_POLICY_BASE_URI, RestRequest.Method.POST, LEGACY_CHANGE_POLICY_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_ism/change_policy/{index}", RestRequest.Method.POST, "/_opendistro/_ism/change_policy/{index}"));
    }

    public String getName() {
        return "change_policy_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("Missing index");
        }
        String indexType = request.param("type", "_default");
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        ChangePolicy changePolicy = ChangePolicy.parse(xcp);
        ChangePolicyRequest changePolicyRequest = new ChangePolicyRequest(Arrays.asList(indices), changePolicy, indexType);
        return channel -> client.execute((ActionType)ChangePolicyAction.INSTANCE, (ActionRequest)changePolicyRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

