/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.resthandler;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.indexstatemanagement.model.ExplainFilter;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.explain.ExplainAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.explain.ExplainRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestExplainAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestExplainAction.class);
    public static final String EXPLAIN_BASE_URI = "/_plugins/_ism/explain";
    public static final String LEGACY_EXPLAIN_BASE_URI = "/_opendistro/_ism/explain";

    public List<RestHandler.Route> routes() {
        return List.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.GET, EXPLAIN_BASE_URI, RestRequest.Method.GET, LEGACY_EXPLAIN_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_ism/explain/{index}", RestRequest.Method.GET, "/_opendistro/_ism/explain/{index}"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, EXPLAIN_BASE_URI, RestRequest.Method.POST, LEGACY_EXPLAIN_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_ism/explain/{index}", RestRequest.Method.POST, "/_opendistro/_ism/explain/{index}"));
    }

    public String getName() {
        return "ism_explain_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        log.debug("{} {}", (Object)request.method(), (Object)request.path());
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        SearchParams searchParams = io.lucenia.indexmanagement.util.RestHandlerUtils.getSearchParams(request, "managed_index.index");
        String indexType = request.param("type", "_default");
        ExplainFilter explainFilter = null;
        if (request.method() == RestRequest.Method.POST) {
            try {
                XContentParser xcp = request.contentParser();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                explainFilter = ExplainFilter.parse(xcp);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse explain filter", e);
            }
        }
        TimeValue clusterManagerTimeout = RestHandlerUtils.parseClusterManagerTimeout(request, DeprecationLogger.getLogger(RestExplainAction.class), this.getName());
        ExplainRequest explainRequest = new ExplainRequest(Arrays.asList(indices), request.paramAsBoolean("local", false), clusterManagerTimeout, searchParams, explainFilter, request.paramAsBoolean("show_policy", false), request.paramAsBoolean("validate_action", false), indexType);
        return channel -> client.execute((ActionType)ExplainAction.INSTANCE, (ActionRequest)explainRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

