/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.resthandler;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPoliciesAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPoliciesRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPolicyAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPolicyRequest;
import io.lucenia.indexmanagement.util.RestHandlerUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetPolicyAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestGetPolicyAction.class);

    public List<RestHandler.Route> routes() {
        return List.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_ism/policies", RestRequest.Method.GET, "/_opendistro/_ism/policies"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_ism/policies/{policyID}", RestRequest.Method.GET, "/_opendistro/_ism/policies/{policyID}"), new RestHandler.ReplacedRoute(RestRequest.Method.HEAD, "/_plugins/_ism/policies/{policyID}", RestRequest.Method.HEAD, "/_opendistro/_ism/policies/{policyID}"));
    }

    public String getName() {
        return "get_policy_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        log.debug("{} {}", (Object)request.method(), (Object)request.path());
        String policyId = request.param("policyID");
        FetchSourceContext fetchSrcContext = request.method() == RestRequest.Method.HEAD ? FetchSourceContext.DO_NOT_FETCH_SOURCE : FetchSourceContext.FETCH_SOURCE;
        SearchParams searchParams = RestHandlerUtils.getSearchParams(request, "policy.policy_id.keyword");
        return channel -> {
            if (policyId == null || policyId.isEmpty()) {
                GetPoliciesRequest getPoliciesRequest = new GetPoliciesRequest(searchParams);
                client.execute((ActionType)GetPoliciesAction.INSTANCE, (ActionRequest)getPoliciesRequest, (ActionListener)new RestToXContentListener(channel));
            } else {
                GetPolicyRequest getPolicyRequest = new GetPolicyRequest(policyId, RestActions.parseVersion((RestRequest)request), fetchSrcContext);
                client.execute((ActionType)GetPolicyAction.INSTANCE, (ActionRequest)getPolicyRequest, (ActionListener)new RestToXContentListener(channel));
            }
        };
    }
}

