/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.resthandler;

import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyResponse;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestResponseListener;

public class RestIndexPolicyAction
extends BaseRestHandler {
    private final ClusterService clusterService;
    private volatile List<String> allowList;

    public RestIndexPolicyAction(Settings settings, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.allowList = (List)ManagedIndexSettings.ALLOW_LIST.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.ALLOW_LIST, value -> {
            this.allowList = value;
        });
    }

    public List<RestHandler.Route> routes() {
        return List.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_ism/policies", RestRequest.Method.PUT, "/_opendistro/_ism/policies"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_ism/policies/{policyID}", RestRequest.Method.PUT, "/_opendistro/_ism/policies/{policyID}"));
    }

    public String getName() {
        return "index_policy_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("policyID", "");
        if ("".equals(id)) {
            throw new IllegalArgumentException("Missing policy ID");
        }
        Policy parsedPolicy = LuceniaExtensions.parseWithType(request.contentParser(), id, Policy::parse);
        Policy policy = new Policy.Builder(parsedPolicy).lastUpdatedTime(Instant.now()).build();
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        List<String> disallowedActions = policy.getDisallowedActions(this.allowList);
        if (!disallowedActions.isEmpty()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "You have actions that are not allowed in your policy " + String.valueOf(disallowedActions)));
        }
        IndexPolicyRequest indexPolicyRequest = new IndexPolicyRequest(id, policy, seqNo, primaryTerm, refreshPolicy);
        return channel -> client.execute((ActionType)IndexPolicyAction.INSTANCE, (ActionRequest)indexPolicyRequest, (ActionListener)new RestResponseListener<IndexPolicyResponse>(this, channel){

            public RestResponse buildResponse(IndexPolicyResponse response) throws Exception {
                BytesRestResponse restResponse = new BytesRestResponse(response.getStatus(), response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (response.getStatus() == RestStatus.CREATED) {
                    String location = "/_plugins/_ism/policies/" + response.getId();
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        });
    }
}

