/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.resthandler;

import io.lucenia.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex.RetryFailedManagedIndexAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex.RetryFailedManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestRetryFailedManagedIndexAction
extends BaseRestHandler {
    public static final String RETRY_BASE_URI = "/_plugins/_ism/retry";
    public static final String LEGACY_RETRY_BASE_URI = "/_opendistro/_ism/retry";

    public List<RestHandler.Route> routes() {
        return List.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, RETRY_BASE_URI, RestRequest.Method.POST, LEGACY_RETRY_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_ism/retry/{index}", RestRequest.Method.POST, "/_opendistro/_ism/retry/{index}"));
    }

    public String getName() {
        return "retry_failed_managed_index";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("Missing indices");
        }
        Map body = request.hasContent() ? (Map)XContentHelper.convertToMap((BytesReference)request.requiredContent(), (boolean)false, (MediaType)request.getMediaType()).v2() : Map.of();
        String indexType = request.param("type", "_default");
        TimeValue clusterManagerTimeout = RestHandlerUtils.parseClusterManagerTimeout(request, DeprecationLogger.getLogger(RestRetryFailedManagedIndexAction.class), this.getName());
        RetryFailedManagedIndexRequest retryFailedRequest = new RetryFailedManagedIndexRequest(Arrays.asList(indices), (String)body.get("state"), clusterManagerTimeout, indexType);
        return channel -> client.execute((ActionType)RetryFailedManagedIndexAction.INSTANCE, (ActionRequest)retryFailedRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

