/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.alias;

import io.lucenia.indexmanagement.indexstatemanagement.action.AliasAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptAliasActionsStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final AliasAction action;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final Set<String> validTopContextFields = Set.of("index");
    public static final String name = "attempt_alias";

    public AttemptAliasActionsStep(AliasAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        this.action.getActions().forEach(it -> {
            it.indices(new String[]{indexName});
            request.addAliasAction(it);
        });
        this.getContext().getClient().admin().indices().aliases(request, ActionListener.wrap(response -> {
            this.handleResponse((AcknowledgedResponse)response, indexName, this.action.getActions());
            future.complete(this);
        }, e -> {
            this.handleException((Exception)e, indexName, this.action.getActions());
            future.complete(this);
        }));
        return future;
    }

    private void handleException(Exception e, String indexName, List<IndicesAliasesRequest.AliasActions> actions) {
        String message = AttemptAliasActionsStep.getFailedMessage(indexName, actions);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    private void handleResponse(AcknowledgedResponse response, String indexName, List<IndicesAliasesRequest.AliasActions> actions) {
        if (response.isAcknowledged()) {
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptAliasActionsStep.getSuccessMessage(indexName));
        } else {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", AttemptAliasActionsStep.getFailedMessage(indexName, actions));
        }
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String index, List<IndicesAliasesRequest.AliasActions> actions) {
        return "Failed to update alias [index=" + index + "] for actions: [actions=" + String.valueOf(actions) + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully updated alias [index=" + index + "]";
    }
}

