/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.allocation;

import io.lucenia.indexmanagement.indexstatemanagement.action.AllocationAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptAllocationStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final AllocationAction action;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    private static final String SETTINGS_PREFIX = "index.routing.allocation.";
    public static final String name = "attempt_allocation";

    public AttemptAllocationStep(AllocationAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        UpdateSettingsRequest request = new UpdateSettingsRequest(this.buildSettings(), new String[]{indexName});
        this.getContext().getClient().admin().indices().updateSettings(request, ActionListener.wrap(response -> {
            this.handleResponse((AcknowledgedResponse)response, indexName);
            future.complete(this);
        }, e -> {
            this.handleException((Exception)e, indexName);
            future.complete(this);
        }));
        return future;
    }

    private Settings buildSettings() {
        Settings.Builder builder = Settings.builder();
        this.action.getRequire().forEach((key, value) -> builder.put("index.routing.allocation.require." + key, value));
        this.action.getInclude().forEach((key, value) -> builder.put("index.routing.allocation.include." + key, value));
        this.action.getExclude().forEach((key, value) -> builder.put("index.routing.allocation.exclude." + key, value));
        return builder.build();
    }

    private void handleException(Exception e, String indexName) {
        String message = AttemptAllocationStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    private void handleResponse(AcknowledgedResponse response, String indexName) {
        if (response.isAcknowledged()) {
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptAllocationStep.getSuccessMessage(indexName));
        } else {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", AttemptAllocationStep.getFailedMessage(indexName));
        }
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String index) {
        return "Failed to update allocation setting [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully updated allocation setting [index=" + index + "]";
    }
}

