/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.forcemerge;

import io.lucenia.indexmanagement.indexstatemanagement.action.ForceMergeAction;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeRequest;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeResponse;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptCallForceMergeStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ForceMergeAction action;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "attempt_call_force_merge";
    public static final long FIVE_MINUTES_IN_MILLIS = 300000L;
    public static final long FIVE_SECONDS_IN_MILLIS = 5000L;

    public AttemptCallForceMergeStep(ForceMergeAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        long startTime = Instant.now().toEpochMilli();
        ForceMergeRequest request = new ForceMergeRequest(new String[]{indexName}).maxNumSegments(this.action.getMaxNumSegments());
        AtomicReference<Object> responseRef = new AtomicReference<Object>(null);
        AtomicReference<Object> throwableRef = new AtomicReference<Object>(null);
        AtomicBoolean completed = new AtomicBoolean(false);
        this.getContext().getClient().admin().indices().forceMerge(request, ActionListener.wrap(response -> {
            responseRef.set(response);
            completed.set(true);
            if (response.getStatus() == RestStatus.OK) {
                this.logger.info(AttemptCallForceMergeStep.getSuccessMessage(indexName));
            } else {
                this.logger.warn(AttemptCallForceMergeStep.getFailedMessage(indexName));
            }
        }, e -> {
            throwableRef.set(e);
            completed.set(true);
        }));
        this.pollForCompletion(indexName, startTime, responseRef, throwableRef, completed, future);
        return future;
    }

    private void pollForCompletion(String indexName, long startTime, AtomicReference<ForceMergeResponse> responseRef, AtomicReference<Throwable> throwableRef, AtomicBoolean completed, CompletableFuture<Step> future) {
        if (completed.get()) {
            this.handleCompletion(indexName, responseRef.get(), throwableRef.get(), future);
            return;
        }
        if (Instant.now().toEpochMilli() - startTime >= 300000L) {
            this.handleCompletion(indexName, responseRef.get(), throwableRef.get(), future);
            return;
        }
        this.getContext().getClient().threadPool().schedule(() -> this.pollForCompletion(indexName, startTime, responseRef, throwableRef, completed, future), TimeValue.timeValueMillis((long)5000L), "generic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompletion(String indexName, ForceMergeResponse response, Throwable throwable, CompletableFuture<Step> future) {
        try {
            if (throwable != null) {
                Throwable cause = throwable;
                if (throwable instanceof RemoteTransportException) {
                    cause = SkyliteExceptionsHelper.unwrapCause((Throwable)throwable);
                }
                this.handleException(indexName, (Exception)cause);
            } else if (response != null && response.getStatus() == RestStatus.OK) {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", AttemptCallForceMergeStep.getSuccessMessage(indexName));
            } else if (response == null) {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", AttemptCallForceMergeStep.getSuccessfulCallMessage(indexName));
            } else {
                this.stepStatus = Step.StepStatus.FAILED;
                ArrayList<String> shardFailures = new ArrayList<String>();
                if (response.getShardFailures() != null) {
                    for (DefaultShardOperationFailedException failure : response.getShardFailures()) {
                        shardFailures.add(LuceniaExtensions.getUsefulCauseString(failure));
                    }
                }
                HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
                mutableInfo.put("message", AttemptCallForceMergeStep.getFailedMessage(indexName));
                mutableInfo.put("status", response.getStatus());
                mutableInfo.put("shard_failures", shardFailures);
                this.info = Map.copyOf(mutableInfo);
            }
        }
        finally {
            future.complete(this);
        }
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptCallForceMergeStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        ActionMetaData updatedActionMetaData = currentMetadata.getActionMetaData() != null ? new ActionMetaData.Builder(currentMetadata.getActionMetaData()).actionProperties(new ActionProperties(Integer.valueOf(this.action.getMaxNumSegments()), null, null, null, null, null)).build() : null;
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(updatedActionMetaData).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return false;
    }

    public static String getFailedMessage(String index) {
        return "Failed to start force merge [index=" + index + "]";
    }

    public static String getSuccessfulCallMessage(String index) {
        return "Successfully called force merge [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully completed force merge [index=" + index + "]";
    }
}

