/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.forcemerge;

import io.lucenia.indexmanagement.indexstatemanagement.action.ForceMergeAction;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptSetReadOnlyStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ForceMergeAction action;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "attempt_set_read_only";

    public AttemptSetReadOnlyStep(ForceMergeAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest().indices(new String[]{indexName}).settings(Settings.builder().put(IndexMetadata.SETTING_BLOCKS_WRITE, true));
        this.getContext().getClient().admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", AttemptSetReadOnlyStep.getSuccessMessage(indexName));
            } else {
                String message = AttemptSetReadOnlyStep.getFailedMessage(indexName);
                this.logger.warn(message);
                this.stepStatus = Step.StepStatus.FAILED;
                this.info = Map.of("message", message);
            }
            future.complete(this);
        }, e -> {
            Throwable cause = e;
            if (e instanceof RemoteTransportException) {
                cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
            }
            this.handleException(indexName, (Exception)cause);
            future.complete(this);
        }));
        return future;
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptSetReadOnlyStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String index) {
        return "Failed to set index to read-only [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully set index to read-only [index=" + index + "]";
    }
}

