/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.forcemerge;

import io.lucenia.indexmanagement.indexstatemanagement.action.ForceMergeAction;
import io.lucenia.indexmanagement.indexstatemanagement.util.StepUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.rest.RestStatus;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaitForForceMergeStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ForceMergeAction action;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "wait_for_force_merge";
    public static final long FORCE_MERGE_TIMEOUT_IN_SECONDS = 43200L;

    public WaitForForceMergeStep(ForceMergeAction action) {
        super(name, false);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        Integer maxNumSegments = this.getMaxNumSegments();
        if (maxNumSegments == null) {
            future.complete(this);
        }
        IndicesStatsRequest statsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{indexName});
        this.getContext().getClient().admin().indices().stats(statsRequest, ActionListener.wrap(statsResponse -> {
            if (statsResponse.getStatus() == RestStatus.OK) {
                this.processShardsStats(indexName, maxNumSegments, (IndicesStatsResponse)statsResponse);
            } else {
                String message = WaitForForceMergeStep.getFailedSegmentCheckMessage(indexName);
                this.logger.warn(message + " - " + String.valueOf(statsResponse.getStatus()));
                this.stepStatus = Step.StepStatus.FAILED;
                ArrayList<String> shardFailures = new ArrayList<String>();
                if (statsResponse.getShardFailures() != null) {
                    for (DefaultShardOperationFailedException failure : statsResponse.getShardFailures()) {
                        shardFailures.add(LuceniaExtensions.getUsefulCauseString(failure));
                    }
                }
                HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
                mutableInfo.put("message", message);
                mutableInfo.put("shard_failures", shardFailures);
                this.info = Map.copyOf(mutableInfo);
            }
            future.complete(this);
        }, e -> {
            this.handleException(indexName, (Exception)e);
            future.complete(this);
        }));
        return future;
    }

    private Integer getMaxNumSegments() {
        ActionProperties actionProperties;
        ActionMetaData actionMetaData = this.getContext().getMetadata().getActionMetaData();
        ActionProperties actionProperties2 = actionProperties = actionMetaData != null ? actionMetaData.getActionProperties() : null;
        if (actionProperties == null || actionProperties.getMaxNumSegments() == null) {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", "Unable to retrieve [" + ActionProperties.Properties.MAX_NUM_SEGMENTS.getKey() + "] from ActionProperties=" + String.valueOf(actionProperties));
            return null;
        }
        return actionProperties.getMaxNumSegments();
    }

    private void processShardsStats(String indexName, int maxNumSegments, IndicesStatsResponse statsResponse) {
        long shardsStillMergingSegments = 0L;
        for (ShardStats shardStats : statsResponse.getShards()) {
            Long count;
            Long l = count = shardStats.getStats().getSegments() != null ? Long.valueOf(shardStats.getStats().getSegments().getCount()) : null;
            if (count == null) {
                this.logger.warn(indexName + " wait for force merge had null segments");
                continue;
            }
            if (count <= (long)maxNumSegments) continue;
            ++shardsStillMergingSegments;
        }
        if (shardsStillMergingSegments == 0L) {
            String message = WaitForForceMergeStep.getSuccessMessage(indexName);
            this.logger.info(message);
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", message);
        } else {
            this.checkTimeout(indexName, shardsStillMergingSegments);
        }
    }

    private void checkTimeout(String indexName, long shardsStillMergingSegments) {
        long timeoutInSeconds;
        Instant actionStartTime = StepUtils.getActionStartTime(this.getContext().getMetadata());
        Duration timeWaitingForForceMerge = Duration.between(actionStartTime, Instant.now());
        long l = timeoutInSeconds = this.action.getConfigTimeout() != null && this.action.getConfigTimeout().getTimeout() != null ? this.action.getConfigTimeout().getTimeout().getSeconds() : 43200L;
        if (timeWaitingForForceMerge.getSeconds() > timeoutInSeconds) {
            this.logger.error("Force merge on [" + indexName + "] timed out with [" + shardsStillMergingSegments + "] shards containing unmerged segments");
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", WaitForForceMergeStep.getFailedTimedOutMessage(indexName));
        } else {
            this.logger.debug("Force merge still running on [" + indexName + "] with [" + shardsStillMergingSegments + "] shards containing unmerged segments");
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            this.info = Map.of("message", WaitForForceMergeStep.getWaitingMessage(indexName));
        }
    }

    private void handleException(String indexName, Exception e) {
        String message = WaitForForceMergeStep.getFailedSegmentCheckMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData;
        ActionMetaData updatedActionMetaData = currentActionMetaData = currentMetadata.getActionMetaData();
        if (currentActionMetaData != null && this.stepStatus == Step.StepStatus.COMPLETED) {
            updatedActionMetaData = new ActionMetaData.Builder(currentActionMetaData).actionProperties(null).build();
        }
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(updatedActionMetaData).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedTimedOutMessage(String index) {
        return "Force merge timed out [index=" + index + "]";
    }

    public static String getFailedSegmentCheckMessage(String index) {
        return "Failed to check segments when waiting for force merge to complete [index=" + index + "]";
    }

    public static String getWaitingMessage(String index) {
        return "Waiting for force merge to complete [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully confirmed segments force merged [index=" + index + "]";
    }
}

