/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.notification;

import io.lucenia.indexmanagement.indexstatemanagement.action.NotificationAction;
import io.lucenia.indexmanagement.indexstatemanagement.util.NotificationUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptNotificationStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final NotificationAction action;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "attempt_notification";
    public static final String CHANNEL_TITLE = "Index Management-ISM-Notification Action";

    public AttemptNotificationStep(NotificationAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        ScriptService scriptService = this.getContext().getScriptService();
        try {
            String compiledMessage = this.compileTemplate(scriptService, this.action.getMessageTemplate(), this.getContext().getMetadata());
            if (this.action.getDestination() != null) {
                NotificationUtils.publishLegacyNotification(this.action.getDestination().buildLegacyBaseMessage(null, compiledMessage), this.getContext().getClient());
            }
            if (this.action.getChannel() != null) {
                NotificationUtils.sendNotification(this.action.getChannel(), this.getContext().getClient(), CHANNEL_TITLE, this.getContext().getMetadata(), compiledMessage, this.getContext().getUser());
            }
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptNotificationStep.getSuccessMessage(indexName));
        }
        catch (Exception e) {
            this.handleException(indexName, e);
        }
        future.complete(this);
        return future;
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptNotificationStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    private String compileTemplate(ScriptService scriptService, Script template, ManagedIndexMetaData managedIndexMetaData) throws IOException {
        HashMap<String, Object> contextMap = new HashMap<String, Object>(LuceniaExtensions.convertToMap((ToXContent)managedIndexMetaData));
        return ((TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT)).newInstance(Map.of("ctx", contextMap)).execute();
    }

    public boolean isIdempotent() {
        return false;
    }

    public static String getFailedMessage(String index) {
        return "Failed to send notification [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully sent notification [index=" + index + "]";
    }
}

