/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.open;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.open.OpenIndexRequest;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptOpenStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "attempt_open";

    public AttemptOpenStep() {
        super(name);
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        OpenIndexRequest openIndexRequest = new OpenIndexRequest().indices(new String[]{indexName});
        this.getContext().getClient().admin().indices().open(openIndexRequest, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", AttemptOpenStep.getSuccessMessage(indexName));
            } else {
                String message = AttemptOpenStep.getFailedMessage(indexName);
                this.logger.warn(message);
                this.stepStatus = Step.StepStatus.FAILED;
                this.info = Map.of("message", message);
            }
            future.complete(this);
        }, e -> {
            Throwable cause = e;
            if (e instanceof RemoteTransportException) {
                cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
            }
            this.handleException(indexName, (Exception)cause);
            future.complete(this);
        }));
        return future;
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptOpenStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String indexName) {
        return "Failed to open index [index=" + indexName + "]";
    }

    public static String getSuccessMessage(String indexName) {
        return "Successfully opened index [index=" + indexName + "]";
    }
}

