/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.replicacount;

import io.lucenia.indexmanagement.indexstatemanagement.action.ReplicaCountAction;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptReplicaCountStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ReplicaCountAction action;
    private final int numOfReplicas;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "attempt_set_replica_count";

    public AttemptReplicaCountStep(ReplicaCountAction action) {
        super(name);
        this.action = action;
        this.numOfReplicas = action.getNumOfReplicas();
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
        }
        String indexName = this.getContext().getMetadata().getIndex();
        UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest().indices(new String[]{indexName}).settings(Settings.builder().put("index.number_of_replicas", this.numOfReplicas));
        this.getContext().getClient().admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", AttemptReplicaCountStep.getSuccessMessage(indexName, this.numOfReplicas));
            } else {
                String message = AttemptReplicaCountStep.getFailedMessage(indexName, this.numOfReplicas);
                this.logger.warn(message);
                this.stepStatus = Step.StepStatus.FAILED;
                this.info = Map.of("message", message);
            }
            future.complete(this);
        }, e -> {
            Throwable cause = e;
            if (e instanceof RemoteTransportException) {
                cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
            }
            this.handleException(indexName, this.numOfReplicas, (Exception)cause);
            future.complete(this);
        }));
        return future;
    }

    private void handleException(String indexName, int numOfReplicas, Exception e) {
        String message = AttemptReplicaCountStep.getFailedMessage(indexName, numOfReplicas);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, String> mutableInfo = new HashMap<String, String>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String index, int numOfReplicas) {
        return "Failed to set number_of_replicas to " + numOfReplicas + " [index=" + index + "]";
    }

    public static String getSuccessMessage(String index, int numOfReplicas) {
        return "Successfully set number_of_replicas to " + numOfReplicas + " [index=" + index + "]";
    }
}

