/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.restore;

import io.lucenia.indexmanagement.indexstatemanagement.action.ConvertIndexToRemoteAction;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.ScriptType;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.snapshots.SnapshotException;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotState;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptRestoreStep
extends Step {
    private final ConvertIndexToRemoteAction action;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    private String snapshotName = null;
    public static final Set<String> validTopContextFields = Set.of("index", "indexUuid");
    public static final String name = "attempt_restore";

    public AttemptRestoreStep(ConvertIndexToRemoteAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        ManagedIndexMetaData managedIndexMetadata = context.getMetadata();
        String indexName = managedIndexMetadata.getIndex();
        ScriptService scriptService = context.getScriptService();
        String repository = this.action.getRepository();
        String snapshot = this.action.getSnapshot();
        try {
            HashMap mutableInfo = new HashMap();
            Script snapshotScript = new Script(ScriptType.INLINE, "mustache", snapshot, Map.of());
            String defaultSnapshotPattern = snapshot.isBlank() ? indexName : snapshot;
            String snapshotPattern = this.compileTemplate(snapshotScript, managedIndexMetadata, defaultSnapshotPattern, scriptService);
            GetSnapshotsRequest getSnapshotsRequest = new GetSnapshotsRequest().repository(repository).snapshots(new String[]{snapshotPattern + "*"}).ignoreUnavailable(true).verbose(true);
            context.getClient().admin().cluster().getSnapshots(getSnapshotsRequest, ActionListener.wrap(response -> this.handleGetSnapshotsResponse((GetSnapshotsResponse)response, snapshotPattern, indexName, repository, context, future, mutableInfo), e -> {
                if (e instanceof RemoteTransportException) {
                    Exception cause = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof SnapshotException) {
                        this.handleRestoreException(indexName, (SnapshotException)cause);
                    } else {
                        this.handleException(indexName, cause);
                    }
                } else if (e instanceof SnapshotException) {
                    this.handleRestoreException(indexName, (SnapshotException)e);
                } else {
                    this.handleException(indexName, (Exception)e);
                }
                future.complete(this);
            }));
        }
        catch (Exception e2) {
            this.handleException(indexName, e2);
            future.complete(this);
        }
        return future;
    }

    private void handleGetSnapshotsResponse(GetSnapshotsResponse response, String snapshotPattern, String indexName, String repository, StepContext context, CompletableFuture<Step> future, Map<String, String> mutableInfo) {
        List snapshots = response.getSnapshots();
        if (snapshots == null || snapshots.isEmpty()) {
            String message = AttemptRestoreStep.getFailedMessage(indexName, "No snapshots found matching pattern [" + snapshotPattern + "*]");
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", message);
            future.complete(this);
            return;
        }
        List successfulSnapshots = snapshots.stream().filter(s -> s.state() == SnapshotState.SUCCESS).collect(Collectors.toList());
        if (successfulSnapshots.isEmpty()) {
            String message = AttemptRestoreStep.getFailedMessage(indexName, "No successful snapshots found matching pattern [" + snapshotPattern + "*]");
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", message);
            future.complete(this);
            return;
        }
        SnapshotInfo latestSnapshotInfo = successfulSnapshots.stream().max(Comparator.comparingLong(SnapshotInfo::endTime)).orElse(null);
        if (latestSnapshotInfo == null) {
            String message = AttemptRestoreStep.getFailedMessage(indexName, "Could not find latest snapshot");
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", message);
            future.complete(this);
            return;
        }
        this.logger.info("Restoring snapshot info: " + String.valueOf(latestSnapshotInfo));
        this.snapshotName = latestSnapshotInfo.snapshotId().getName();
        RestoreSnapshotRequest restoreSnapshotRequest = new RestoreSnapshotRequest(repository, this.snapshotName).indices(new String[]{indexName}).storageType(RestoreSnapshotRequest.StorageType.REMOTE_SNAPSHOT).renamePattern("^(.*)$").renameReplacement("$1_remote").waitForCompletion(false);
        context.getClient().admin().cluster().restoreSnapshot(restoreSnapshotRequest, ActionListener.wrap(restoreResponse -> {
            this.handleRestoreResponse((RestoreSnapshotResponse)restoreResponse, indexName, mutableInfo);
            future.complete(this);
        }, e -> {
            if (e instanceof RemoteTransportException) {
                Exception cause = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof SnapshotException) {
                    this.handleRestoreException(indexName, (SnapshotException)cause);
                } else {
                    this.handleException(indexName, cause);
                }
            } else if (e instanceof SnapshotException) {
                this.handleRestoreException(indexName, (SnapshotException)e);
            } else {
                this.handleException(indexName, (Exception)e);
            }
            future.complete(this);
        }));
    }

    private void handleRestoreResponse(RestoreSnapshotResponse response, String indexName, Map<String, String> mutableInfo) {
        if (response.status() == RestStatus.ACCEPTED || response.status() == RestStatus.OK) {
            this.stepStatus = Step.StepStatus.COMPLETED;
            mutableInfo.put("message", AttemptRestoreStep.getSuccessMessage(indexName));
        } else {
            String message = AttemptRestoreStep.getFailedMessage(indexName, "Unexpected response status: " + String.valueOf(response.status()));
            this.logger.warn(message + " - " + String.valueOf(response));
            this.stepStatus = Step.StepStatus.FAILED;
            mutableInfo.put("message", message);
            mutableInfo.put("cause", response.toString());
        }
        this.info = new HashMap<String, String>(mutableInfo);
    }

    private String compileTemplate(Script template, ManagedIndexMetaData managedIndexMetaData, String defaultValue, ScriptService scriptService) {
        try {
            Map<String, Object> contextMap = LuceniaExtensions.convertToMap((ToXContent)managedIndexMetaData);
            HashMap<String, Object> filteredContext = new HashMap<String, Object>();
            for (String key : validTopContextFields) {
                if (!contextMap.containsKey(key)) continue;
                filteredContext.put(key, contextMap.get(key));
            }
            HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>(template.getParams());
            params.put("ctx", filteredContext);
            String compiledValue = ((TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT)).newInstance(params).execute();
            return compiledValue.isBlank() ? defaultValue : compiledValue;
        }
        catch (Exception e) {
            this.logger.error("Failed to compile template", (Throwable)e);
            return defaultValue;
        }
    }

    private void handleRestoreException(String indexName, SnapshotException e) {
        String message = AttemptRestoreStep.getFailedRestoreMessage(indexName);
        this.logger.debug(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = mutableInfo;
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptRestoreStep.getFailedMessage(indexName, e.getMessage() != null ? e.getMessage() : "Unknown error");
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = mutableInfo;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData = currentMetadata.getActionMetaData();
        ActionMetaData updatedActionMetaData = currentActionMetaData != null ? new ActionMetaData.Builder(currentActionMetaData).actionProperties(new ActionProperties(null, this.snapshotName, null, null, null, null)).build() : null;
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(updatedActionMetaData).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return false;
    }

    public static String getFailedMessage(String index, String cause) {
        return "Failed to start restore for [index=" + index + "], cause: " + cause;
    }

    public static String getFailedRestoreMessage(String index) {
        return "Failed to start restore due to concurrent restore or snapshot in progress [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully started restore for [index=" + index + "]";
    }
}

