/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.rollover;

import io.lucenia.indexmanagement.indexstatemanagement.action.RolloverAction;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesRequest;
import io.skylite.core.action.admin.indices.rollover.RolloverRequest;
import io.skylite.core.action.admin.indices.rollover.RolloverResponse;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptRolloverStep
extends Step {
    private final RolloverAction action;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    private String newIndex = null;
    public static final String name = "attempt_rollover";

    public AttemptRolloverStep(RolloverAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        final CompletableFuture<Step> future = new CompletableFuture<Step>();
        final StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        String indexName = context.getMetadata().getIndex();
        ClusterService clusterService = context.getClusterService();
        boolean skipRollover = LuceniaExtensions.getRolloverSkip(clusterService.state().metadata().index(indexName));
        if (skipRollover) {
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptRolloverStep.getSkipRolloverMessage(indexName));
            future.complete(this);
            return future;
        }
        RolloverTargetResult rolloverTargetResult = this.getRolloverTargetOrUpdateInfo(context);
        if (rolloverTargetResult.rolloverTarget == null) {
            future.complete(this);
            return future;
        }
        final String rolloverTarget = rolloverTargetResult.rolloverTarget;
        final boolean isDataStream = rolloverTargetResult.isDataStream;
        if (clusterService.state().metadata().index(indexName).getRolloverInfos().containsKey(rolloverTarget)) {
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptRolloverStep.getAlreadyRolledOverMessage(indexName, rolloverTarget));
            this.copyAlias(clusterService, indexName, context.getClient(), rolloverTarget, context.getMetadata(), (ActionListener<Step>)ActionListener.wrap(step -> future.complete((Step)step), e -> future.completeExceptionally((Throwable)e)));
            return future;
        }
        if (!isDataStream && !this.preCheckIndexAlias(context, rolloverTarget)) {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", AttemptRolloverStep.getFailedPreCheckMessage(indexName));
            future.complete(this);
            return future;
        }
        this.getIndexStatsOrUpdateInfo(context, new ActionListener<IndicesStatsResponse>(){

            public void onResponse(IndicesStatsResponse statsResponse) {
                if (statsResponse == null) {
                    future.complete(AttemptRolloverStep.this);
                    return;
                }
                AttemptRolloverStep.this.processStatsAndRollover(context, statsResponse, rolloverTarget, isDataStream, (ActionListener<Step>)ActionListener.wrap(step -> future.complete(step), e -> future.completeExceptionally((Throwable)e)));
            }

            public void onFailure(Exception e) {
                future.complete(AttemptRolloverStep.this);
            }
        });
        return future;
    }

    private void processStatsAndRollover(final StepContext context, IndicesStatsResponse statsResponse, final String rolloverTarget, boolean isDataStream, final ActionListener<Step> listener) {
        TimeValue indexAgeTimeValue;
        final String indexName = context.getMetadata().getIndex();
        final ClusterService clusterService = context.getClusterService();
        long indexCreationDate = clusterService.state().metadata().index(indexName).getCreationDate();
        if (indexCreationDate == -1L) {
            this.logger.warn(indexName + " had an indexCreationDate=-1L, cannot use for comparison");
            indexAgeTimeValue = TimeValue.timeValueMillis((long)0L);
        } else {
            indexAgeTimeValue = TimeValue.timeValueMillis((long)(Instant.now().toEpochMilli() - indexCreationDate));
        }
        long numDocs = statsResponse.getPrimaries().getDocs() != null ? statsResponse.getPrimaries().getDocs().getCount() : 0L;
        ByteSizeValue indexSize = new ByteSizeValue(statsResponse.getPrimaries().getDocs() != null ? statsResponse.getPrimaries().getDocs().getTotalSizeInBytes() : 0L);
        ShardStats largestPrimaryShard = Arrays.stream(statsResponse.getShards()).max(Comparator.comparingLong(s -> s.getStats().getDocs() != null ? s.getStats().getDocs().getTotalSizeInBytes() : 0L)).orElse(null);
        ByteSizeValue largestPrimaryShardSize = new ByteSizeValue(largestPrimaryShard != null && largestPrimaryShard.getStats().getDocs() != null ? largestPrimaryShard.getStats().getDocs().getTotalSizeInBytes() : 0L);
        Map<String, Map<String, Object>> conditions = this.buildConditions(indexAgeTimeValue, indexCreationDate, numDocs, indexSize, largestPrimaryShardSize, largestPrimaryShard != null ? Integer.valueOf(largestPrimaryShard.getShardRouting().id()) : null);
        if (ManagedIndexUtils.evaluateConditions(this.action, indexAgeTimeValue, numDocs, indexSize, largestPrimaryShardSize)) {
            this.logger.info(indexName + " rollover conditions evaluated to true [indexCreationDate=" + indexCreationDate + ", numDocs=" + numDocs + ", indexSize=" + indexSize.getBytes() + ", primaryShardSize=" + largestPrimaryShardSize.getBytes() + "]");
            this.executeRollover(context, rolloverTarget, isDataStream, conditions, new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    AttemptRolloverStep.this.copyAlias(clusterService, indexName, context.getClient(), rolloverTarget, context.getMetadata(), (ActionListener<Step>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onResponse((Object)AttemptRolloverStep.this);
                }
            });
        } else {
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            this.info = Map.of("message", AttemptRolloverStep.getPendingMessage(indexName), "conditions", conditions);
            listener.onResponse((Object)this);
        }
    }

    private Map<String, Map<String, Object>> buildConditions(TimeValue indexAgeTimeValue, long indexCreationDate, long numDocs, ByteSizeValue indexSize, ByteSizeValue largestPrimaryShardSize, Integer shardId) {
        LinkedHashMap<String, Map<String, Object>> conditions = new LinkedHashMap<String, Map<String, Object>>();
        if (this.action.getMinAge() != null) {
            LinkedHashMap<String, Object> minAgeCondition = new LinkedHashMap<String, Object>();
            minAgeCondition.put("condition", this.action.getMinAge().toString());
            minAgeCondition.put("current", indexAgeTimeValue.toString());
            minAgeCondition.put("creationDate", indexCreationDate);
            conditions.put("min_index_age", minAgeCondition);
        }
        if (this.action.getMinDocs() != null) {
            LinkedHashMap<String, Long> minDocsCondition = new LinkedHashMap<String, Long>();
            minDocsCondition.put("condition", this.action.getMinDocs());
            minDocsCondition.put("current", numDocs);
            conditions.put("min_doc_count", minDocsCondition);
        }
        if (this.action.getMinSize() != null) {
            LinkedHashMap<String, String> minSizeCondition = new LinkedHashMap<String, String>();
            minSizeCondition.put("condition", this.action.getMinSize().toString());
            minSizeCondition.put("current", indexSize.toString());
            conditions.put("min_size", minSizeCondition);
        }
        if (this.action.getMinPrimaryShardSize() != null) {
            LinkedHashMap<String, Object> minPrimaryShardSizeCondition = new LinkedHashMap<String, Object>();
            minPrimaryShardSizeCondition.put("condition", this.action.getMinPrimaryShardSize().toString());
            minPrimaryShardSizeCondition.put("current", largestPrimaryShardSize.toString());
            if (shardId != null) {
                minPrimaryShardSizeCondition.put("shard", shardId);
            }
            conditions.put("min_primary_shard_size", minPrimaryShardSizeCondition);
        }
        return conditions;
    }

    private RolloverTargetResult getRolloverTargetOrUpdateInfo(StepContext context) {
        String indexName = context.getMetadata().getIndex();
        Metadata metadata = context.getClusterService().state().metadata();
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexName);
        boolean isDataStreamIndex = indexAbstraction != null && indexAbstraction.getParentDataStream() != null;
        String rolloverTarget = isDataStreamIndex ? indexAbstraction.getParentDataStream().getName() : LuceniaExtensions.getRolloverAlias(metadata.index(indexName));
        if (rolloverTarget == null) {
            String message = AttemptRolloverStep.getFailedNoValidAliasMessage(indexName);
            this.logger.warn(message);
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", message);
        }
        return new RolloverTargetResult(rolloverTarget, isDataStreamIndex);
    }

    private boolean preCheckIndexAlias(StepContext context, String alias) {
        String indexName = context.getMetadata().getIndex();
        Metadata metadata = context.getClusterService().state().metadata();
        IndexMetadata indexMetadata = metadata.index(indexName);
        AliasMetadata indexAlias = indexMetadata != null ? (AliasMetadata)indexMetadata.getAliases().get(alias) : null;
        this.logger.debug("Index " + indexName + " has aliases " + String.valueOf(indexAlias));
        if (indexAlias == null) {
            return false;
        }
        Boolean isWriteIndex = indexAlias.writeIndex();
        if (!Boolean.TRUE.equals(isWriteIndex)) {
            IndexAbstraction aliasAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(alias);
            List aliasIndices = aliasAbstraction != null ? aliasAbstraction.getIndices().stream().map(im -> im.getIndex()).collect(Collectors.toList()) : null;
            this.logger.debug("Alias " + alias + " contains indices " + String.valueOf(aliasIndices));
            if (aliasIndices != null && aliasIndices.size() > 1) {
                return false;
            }
        }
        return true;
    }

    private void getIndexStatsOrUpdateInfo(StepContext context, ActionListener<IndicesStatsResponse> listener) {
        String indexName = context.getMetadata().getIndex();
        try {
            IndicesStatsRequest statsRequest = ((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{indexName})).clear().docs(true);
            context.getClient().admin().indices().stats(statsRequest, ActionListener.wrap(statsResponse -> {
                if (statsResponse.getStatus() == RestStatus.OK) {
                    listener.onResponse(statsResponse);
                } else {
                    String message = AttemptRolloverStep.getFailedEvaluateMessage(indexName);
                    this.logger.warn(message + " - " + String.valueOf(statsResponse.getStatus()));
                    this.stepStatus = Step.StepStatus.FAILED;
                    HashMap<String, Object> failureInfo = new HashMap<String, Object>();
                    failureInfo.put("message", message);
                    List shardFailures = Arrays.stream(statsResponse.getShardFailures()).map(LuceniaExtensions::getUsefulCauseString).collect(Collectors.toList());
                    failureInfo.put("shard_failures", shardFailures);
                    this.info = failureInfo;
                    listener.onResponse(null);
                }
            }, e -> {
                if (e instanceof RemoteTransportException) {
                    this.handleException(indexName, (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                } else {
                    this.handleException(indexName, (Exception)e, AttemptRolloverStep.getFailedEvaluateMessage(indexName));
                }
                listener.onResponse(null);
            }));
        }
        catch (Exception e2) {
            this.handleException(indexName, e2, AttemptRolloverStep.getFailedEvaluateMessage(indexName));
            listener.onResponse(null);
        }
    }

    private void executeRollover(StepContext context, String rolloverTarget, boolean isDataStream, Map<String, Map<String, Object>> conditions, ActionListener<Void> listener) {
        String indexName = context.getMetadata().getIndex();
        try {
            RolloverRequest request = new RolloverRequest(rolloverTarget, null);
            context.getClient().admin().indices().rolloverIndex(request, ActionListener.wrap(response -> {
                this.handleRolloverResponse((RolloverResponse)response, rolloverTarget, isDataStream, indexName, conditions);
                listener.onResponse(null);
            }, e -> {
                if (e instanceof RemoteTransportException) {
                    this.handleException(indexName, (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                } else {
                    this.handleException(indexName, (Exception)e);
                }
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            this.handleException(indexName, e2);
            listener.onFailure(e2);
        }
    }

    private void handleRolloverResponse(RolloverResponse response, String rolloverTarget, boolean isDataStream, String indexName, Map<String, Map<String, Object>> conditions) {
        if (response.isAcknowledged()) {
            String message = isDataStream ? AttemptRolloverStep.getSuccessDataStreamRolloverMessage(rolloverTarget, indexName) : AttemptRolloverStep.getSuccessMessage(indexName);
            this.newIndex = response.getNewIndex();
            this.stepStatus = Step.StepStatus.COMPLETED;
            HashMap<String, Object> successInfo = new HashMap<String, Object>();
            successInfo.put("message", message);
            if (!conditions.isEmpty()) {
                successInfo.put("conditions", conditions);
            }
            this.info = successInfo;
        } else {
            String message = isDataStream ? AttemptRolloverStep.getFailedDataStreamRolloverMessage(rolloverTarget) : AttemptRolloverStep.getFailedAliasUpdateMessage(indexName, response.getNewIndex());
            this.logger.warn(message);
            this.stepStatus = Step.StepStatus.FAILED;
            HashMap<String, Object> failureInfo = new HashMap<String, Object>();
            failureInfo.put("message", message);
            if (!conditions.isEmpty()) {
                failureInfo.put("conditions", conditions);
            }
            this.info = failureInfo;
        }
    }

    private void copyAlias(ClusterService clusterService, String indexName, Client client, String rolloverTarget, ManagedIndexMetaData metadata, ActionListener<Step> listener) {
        String rolledOverIndexName;
        Object conditions;
        if (!this.action.getCopyAlias()) {
            listener.onResponse((Object)this);
            return;
        }
        Object object = conditions = this.info != null ? this.info.get("conditions") : null;
        if (conditions == null && metadata.getInfo() != null) {
            conditions = metadata.getInfo().get("conditions");
        }
        String string = rolledOverIndexName = this.newIndex != null ? this.newIndex : metadata.getRolledOverIndexName();
        if (rolledOverIndexName == null) {
            this.logger.error(indexName + " rolled over but cannot find the rolledOverIndexName to copy aliases to");
            this.stepStatus = Step.StepStatus.COMPLETED;
            HashMap<String, Object> errorInfo = new HashMap<String, Object>();
            errorInfo.put("message", AttemptRolloverStep.getCopyAliasRolledOverIndexNotFoundMessage(indexName));
            if (conditions != null) {
                errorInfo.put("conditions", conditions);
            }
            this.info = errorInfo;
            listener.onResponse((Object)this);
            return;
        }
        ArrayList<IndicesAliasesRequest.AliasActions> aliasActions = new ArrayList<IndicesAliasesRequest.AliasActions>();
        Map aliases = clusterService.state().metadata().index(indexName).getAliases();
        Object finalConditions = conditions;
        for (Map.Entry entry : aliases.entrySet()) {
            String aliasName = (String)entry.getKey();
            if (aliasName.equals(rolloverTarget)) continue;
            AliasMetadata aliasMetadata = (AliasMetadata)entry.getValue();
            IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().index(rolledOverIndexName).alias(aliasMetadata.alias());
            if (aliasMetadata.filter() != null) {
                aliasAction.filter(aliasMetadata.filter().toString());
            }
            if (aliasMetadata.getSearchRouting() != null) {
                aliasAction.searchRouting(aliasMetadata.getSearchRouting());
            }
            if (aliasMetadata.getIndexRouting() != null) {
                aliasAction.indexRouting(aliasMetadata.getIndexRouting());
            }
            if (aliasMetadata.isHidden() != null) {
                aliasAction.isHidden(aliasMetadata.isHidden());
            }
            aliasActions.add(aliasAction);
        }
        IndicesAliasesRequest aliasReq = new IndicesAliasesRequest();
        for (IndicesAliasesRequest.AliasActions action : aliasActions) {
            aliasReq.addAliasAction(action);
        }
        try {
            client.admin().indices().aliases(aliasReq, ActionListener.wrap(aliasRes -> {
                if (aliasRes.isAcknowledged()) {
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    HashMap<String, Object> successInfo = new HashMap<String, Object>();
                    successInfo.put("message", AttemptRolloverStep.getSuccessCopyAliasMessage(indexName, rolledOverIndexName));
                    if (finalConditions != null) {
                        successInfo.put("conditions", finalConditions);
                    }
                    this.info = successInfo;
                } else {
                    this.stepStatus = Step.StepStatus.FAILED;
                    HashMap<String, Object> failureInfo = new HashMap<String, Object>();
                    failureInfo.put("message", AttemptRolloverStep.getCopyAliasNotAckMessage(indexName, rolledOverIndexName));
                    if (finalConditions != null) {
                        failureInfo.put("conditions", finalConditions);
                    }
                    this.info = failureInfo;
                }
                listener.onResponse((Object)this);
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    this.logger.error("Index not found while copying alias from " + indexName + " to " + rolledOverIndexName, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    HashMap<String, Object> failureInfo = new HashMap<String, Object>();
                    failureInfo.put("message", AttemptRolloverStep.getCopyAliasIndexNotFoundMessage(rolledOverIndexName));
                    if (finalConditions != null) {
                        failureInfo.put("conditions", finalConditions);
                    }
                    this.info = failureInfo;
                } else {
                    this.handleException(indexName, (Exception)e, AttemptRolloverStep.getFailedCopyAliasMessage(indexName, rolledOverIndexName), finalConditions);
                }
                listener.onResponse((Object)this);
            }));
        }
        catch (Exception e2) {
            this.handleException(indexName, e2, AttemptRolloverStep.getFailedCopyAliasMessage(indexName, rolledOverIndexName), finalConditions);
            listener.onResponse((Object)this);
        }
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        boolean rolledOver = Boolean.TRUE.equals(currentMetadata.getRolledOver()) || this.stepStatus == Step.StepStatus.COMPLETED;
        String rolledOverIndexName = currentMetadata.getRolledOverIndexName() != null ? currentMetadata.getRolledOverIndexName() : this.newIndex;
        return new ManagedIndexMetaData(currentMetadata.getIndex(), currentMetadata.getIndexUuid(), currentMetadata.getPolicyID(), currentMetadata.getPolicySeqNo(), currentMetadata.getPolicyPrimaryTerm(), currentMetadata.getPolicyCompleted(), Boolean.valueOf(rolledOver), currentMetadata.getIndexCreationDate(), null, currentMetadata.getStateMetaData(), currentMetadata.getActionMetaData(), new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus), currentMetadata.getPolicyRetryInfo(), this.info, currentMetadata.getId(), currentMetadata.getSeqNo(), currentMetadata.getPrimaryTerm(), rolledOverIndexName);
    }

    private void handleException(String indexName, Exception e) {
        this.handleException(indexName, e, AttemptRolloverStep.getFailedMessage(indexName), null);
    }

    private void handleException(String indexName, Exception e, String message) {
        this.handleException(indexName, e, message, null);
    }

    private void handleException(String indexName, Exception e, String message, Object conditions) {
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        if (conditions != null) {
            mutableInfo.put("conditions", conditions);
        }
        this.info = mutableInfo;
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String index) {
        return "Failed to rollover index [index=" + index + "]";
    }

    public static String getFailedAliasUpdateMessage(String index, String newIndex) {
        return "New index created, but failed to update alias [index=" + index + ", newIndex=" + newIndex + "]";
    }

    public static String getFailedDataStreamRolloverMessage(String dataStream) {
        return "Failed to rollover data stream [data_stream=" + dataStream + "]";
    }

    public static String getFailedNoValidAliasMessage(String index) {
        return "Missing rollover_alias index setting [index=" + index + "]";
    }

    public static String getFailedEvaluateMessage(String index) {
        return "Failed to evaluate conditions for rollover [index=" + index + "]";
    }

    public static String getPendingMessage(String index) {
        return "Pending rollover of index [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully rolled over index [index=" + index + "]";
    }

    public static String getSuccessDataStreamRolloverMessage(String dataStream, String index) {
        return "Successfully rolled over data stream [data_stream=" + dataStream + " index=" + index + "]";
    }

    public static String getFailedPreCheckMessage(String index) {
        return "Missing alias or not the write index when rollover [index=" + index + "]";
    }

    public static String getSkipRolloverMessage(String index) {
        return "Skipped rollover action for [index=" + index + "]";
    }

    public static String getAlreadyRolledOverMessage(String index, String alias) {
        return "This index has already been rolled over using this alias, treating as a success [index=" + index + ", alias=" + alias + "]";
    }

    public static String getSuccessCopyAliasMessage(String index, String newIndex) {
        return "Successfully rolled over and copied alias from [index=" + index + "] to [index=" + newIndex + "]";
    }

    public static String getFailedCopyAliasMessage(String index, String newIndex) {
        return "Successfully rolled over but failed to copy alias from [index=" + index + "] to [index=" + newIndex + "]";
    }

    public static String getCopyAliasNotAckMessage(String index, String newIndex) {
        return "Successfully rolled over but copy alias from [index=" + index + "] to [index=" + newIndex + "] is not acknowledged";
    }

    public static String getCopyAliasIndexNotFoundMessage(String newIndex) {
        return "Successfully rolled over but new index [index=" + newIndex + "] not found during copy alias";
    }

    public static String getCopyAliasRolledOverIndexNotFoundMessage(String index) {
        return "Successfully rolled over [index=" + index + "] but ISM cannot find rolled over index from metadata to copy aliases to, please manually copy";
    }

    private static class RolloverTargetResult {
        final String rolloverTarget;
        final boolean isDataStream;

        RolloverTargetResult(String rolloverTarget, boolean isDataStream) {
            this.rolloverTarget = rolloverTarget;
            this.isDataStream = isDataStream;
        }
    }
}

