/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.rollup;

import io.lucenia.indexmanagement.indexstatemanagement.action.RollupAction;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupAction;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupRequest;
import io.lucenia.indexmanagement.rollup.action.start.StartRollupAction;
import io.lucenia.indexmanagement.rollup.action.start.StartRollupRequest;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptCreateRollupJobStep
extends Step {
    private final RollupAction action;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    private String rollupId = null;
    public static final String name = "attempt_create_rollup";

    public AttemptCreateRollupJobStep(RollupAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        String indexName = context.getMetadata().getIndex();
        ManagedIndexMetaData managedIndexMetadata = context.getMetadata();
        String previousRunRollupId = managedIndexMetadata.getActionMetaData() != null && managedIndexMetadata.getActionMetaData().getActionProperties() != null ? managedIndexMetadata.getActionMetaData().getActionProperties().getRollupId() : null;
        Boolean hasPreviousRollupAttemptFailed = managedIndexMetadata.getActionMetaData() != null && managedIndexMetadata.getActionMetaData().getActionProperties() != null ? managedIndexMetadata.getActionMetaData().getActionProperties().getHasRollupFailed() : null;
        Rollup rollup = this.action.getIsmRollup().toRollup(indexName, context.getUser());
        this.rollupId = rollup.getId();
        this.logger.info("Attempting to create a rollup job " + this.rollupId + " for index " + indexName);
        IndexRollupRequest indexRollupRequest = new IndexRollupRequest(rollup, WriteRequest.RefreshPolicy.IMMEDIATE);
        context.getClient().execute((ActionType)IndexRollupAction.INSTANCE, (ActionRequest)indexRollupRequest, ActionListenerHelper.wrap(response -> {
            this.logger.info("Received status " + response.getStatus().getStatus() + " on trying to create rollup job " + this.rollupId);
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptCreateRollupJobStep.getSuccessMessage(rollup.getId(), indexName));
            future.complete(this);
        }, e -> {
            if (e instanceof VersionConflictEngineException) {
                String message = AttemptCreateRollupJobStep.getFailedJobExistsMessage(rollup.getId(), indexName);
                this.logger.info(message);
                if (rollup.getId().equals(previousRunRollupId) && Boolean.TRUE.equals(hasPreviousRollupAttemptFailed)) {
                    this.startRollupJob(rollup.getId(), context, future);
                } else {
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = Map.of("info", message);
                    future.complete(this);
                }
            } else if (e instanceof RemoteTransportException) {
                this.processFailure(rollup.getId(), indexName, (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                future.complete(this);
            } else if (e instanceof SkyliteException) {
                this.processFailure(rollup.getId(), indexName, (Exception)((Object)((SkyliteException)((Object)((Object)e)))));
                future.complete(this);
            } else {
                this.processFailure(rollup.getId(), indexName, (Exception)e);
                future.complete(this);
            }
        }));
        return future;
    }

    public void processFailure(String rollupId, String indexName, Exception e) {
        String message = AttemptCreateRollupJobStep.getFailedMessage(rollupId, indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        mutableInfo.put("cause", e.getMessage() != null ? e.getMessage() : "");
        this.info = mutableInfo;
    }

    private void startRollupJob(String rollupId, StepContext context, CompletableFuture<Step> future) {
        String indexName = context.getMetadata().getIndex();
        this.logger.info("Attempting to re-start the job " + rollupId);
        StartRollupRequest startRollupRequest = new StartRollupRequest(rollupId);
        context.getClient().execute((ActionType)StartRollupAction.INSTANCE, (ActionRequest)startRollupRequest, ActionListenerHelper.wrap(response -> {
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptCreateRollupJobStep.getSuccessRestartMessage(rollupId, indexName));
            future.complete(this);
        }, e -> {
            String message = AttemptCreateRollupJobStep.getFailedToStartMessage(rollupId, indexName);
            this.logger.error(message, (Throwable)e);
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", message);
            future.complete(this);
        }));
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData = currentMetadata.getActionMetaData();
        ActionMetaData updatedActionMetaData = currentActionMetaData != null ? new ActionMetaData.Builder(currentActionMetaData).actionProperties(new ActionProperties(null, null, this.rollupId, null, null, null)).build() : null;
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(updatedActionMetaData).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String rollupId, String index) {
        return "Failed to create the rollup job [" + rollupId + "] [index=" + index + "]";
    }

    public static String getFailedJobExistsMessage(String rollupId, String index) {
        return "Rollup job [" + rollupId + "] already exists, skipping creation [index=" + index + "]";
    }

    public static String getFailedToStartMessage(String rollupId, String index) {
        return "Failed to start the rollup job [" + rollupId + "] [index=" + index + "]";
    }

    public static String getSuccessMessage(String rollupId, String index) {
        return "Successfully created the rollup job [" + rollupId + "] [index=" + index + "]";
    }

    public static String getSuccessRestartMessage(String rollupId, String index) {
        return "Successfully restarted the rollup job [" + rollupId + "] [index=" + index + "]";
    }
}

