/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.rollup;

import io.lucenia.indexmanagement.rollup.action.explain.ExplainRollupAction;
import io.lucenia.indexmanagement.rollup.action.explain.ExplainRollupRequest;
import io.lucenia.indexmanagement.rollup.model.RollupMetadata;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaitForRollupCompletionStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    private Boolean hasRollupFailed = null;
    public static final String name = "wait_for_rollup_completion";
    public static final String JOB_STOPPED_MESSAGE = "Rollup job was stopped";

    public WaitForRollupCompletionStep() {
        super(name);
    }

    public CompletableFuture<Step> execute() {
        String rollupJobId;
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        String indexName = context.getMetadata().getIndex();
        ManagedIndexMetaData managedIndexMetadata = context.getMetadata();
        String string = rollupJobId = managedIndexMetadata.getActionMetaData() != null && managedIndexMetadata.getActionMetaData().getActionProperties() != null ? managedIndexMetadata.getActionMetaData().getActionProperties().getRollupId() : null;
        if (rollupJobId == null) {
            this.logger.error("No rollup job id passed down");
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", WaitForRollupCompletionStep.getMissingRollupJobMessage(indexName));
            future.complete(this);
            return future;
        }
        ExplainRollupRequest explainRollupRequest = new ExplainRollupRequest(Collections.singletonList(rollupJobId));
        context.getClient().execute((ActionType)ExplainRollupAction.INSTANCE, (ActionRequest)explainRollupRequest, ActionListener.wrap(response -> {
            RollupMetadata metadata;
            this.logger.info("Received the status for jobs [" + String.valueOf(response.getIdsToExplain().keySet()) + "]");
            RollupMetadata rollupMetadata = metadata = response.getIdsToExplain().get(rollupJobId) != null ? response.getIdsToExplain().get(rollupJobId).getMetadata() : null;
            if (metadata == null || metadata.getStatus() == null) {
                this.logger.warn("Job " + rollupJobId + " has not started yet");
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = Map.of("message", WaitForRollupCompletionStep.getJobProcessingMessage(rollupJobId, indexName));
            } else {
                this.processRollupMetadataStatus(rollupJobId, indexName, metadata);
            }
            future.complete(this);
        }, e -> {
            this.processFailure(rollupJobId, indexName, (Exception)e);
            future.complete(this);
        }));
        return future;
    }

    public void processRollupMetadataStatus(String rollupJobId, String indexName, RollupMetadata rollupMetadata) {
        switch (rollupMetadata.getStatus()) {
            case INIT: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = Map.of("message", WaitForRollupCompletionStep.getJobProcessingMessage(rollupJobId, indexName));
                break;
            }
            case STARTED: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = Map.of("message", WaitForRollupCompletionStep.getJobProcessingMessage(rollupJobId, indexName));
                break;
            }
            case FAILED: {
                this.stepStatus = Step.StepStatus.FAILED;
                this.hasRollupFailed = true;
                HashMap<String, Object> failedInfo = new HashMap<String, Object>();
                failedInfo.put("message", WaitForRollupCompletionStep.getJobFailedMessage(rollupJobId, indexName));
                failedInfo.put("cause", rollupMetadata.getFailureReason() != null ? rollupMetadata.getFailureReason() : "");
                this.info = failedInfo;
                break;
            }
            case FINISHED: {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", WaitForRollupCompletionStep.getJobCompletionMessage(rollupJobId, indexName));
                break;
            }
            case RETRY: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = Map.of("message", WaitForRollupCompletionStep.getJobProcessingMessage(rollupJobId, indexName));
                break;
            }
            case STOPPED: {
                this.stepStatus = Step.StepStatus.FAILED;
                this.hasRollupFailed = true;
                HashMap<String, Object> stoppedInfo = new HashMap<String, Object>();
                stoppedInfo.put("message", WaitForRollupCompletionStep.getJobFailedMessage(rollupJobId, indexName));
                stoppedInfo.put("cause", JOB_STOPPED_MESSAGE);
                this.info = stoppedInfo;
            }
        }
    }

    public void processFailure(String rollupJobId, String indexName, Exception e) {
        this.stepStatus = Step.StepStatus.FAILED;
        String message = WaitForRollupCompletionStep.getFailedMessage(rollupJobId, indexName);
        this.logger.error(message, (Throwable)e);
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = mutableInfo;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData = currentMetadata.getActionMetaData();
        ActionProperties currentActionProperties = currentActionMetaData != null ? currentActionMetaData.getActionProperties() : null;
        ActionProperties updatedProperties = currentActionProperties != null ? new ActionProperties(currentActionProperties.getMaxNumSegments(), currentActionProperties.getSnapshotName(), currentActionProperties.getRollupId(), this.hasRollupFailed, currentActionProperties.getShrinkActionProperties(), currentActionProperties.getTransformActionProperties()) : null;
        ActionMetaData updatedActionMetaData = currentActionMetaData != null ? new ActionMetaData.Builder(currentActionMetaData).actionProperties(updatedProperties).build() : null;
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(updatedActionMetaData).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String rollupJob, String index) {
        return "Failed to get the status of rollup job [" + rollupJob + "] [index=" + index + "]";
    }

    public static String getJobProcessingMessage(String rollupJob, String index) {
        return "Rollup job [" + rollupJob + "] is still processing [index=" + index + "]";
    }

    public static String getJobCompletionMessage(String rollupJob, String index) {
        return "Rollup job [" + rollupJob + "] completed [index=" + index + "]";
    }

    public static String getJobFailedMessage(String rollupJob, String index) {
        return "Rollup job [" + rollupJob + "] failed [index=" + index + "]";
    }

    public static String getMissingRollupJobMessage(String index) {
        return "Rollup job was not found [index=" + index + "]";
    }
}

