/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.shrink;

import io.lucenia.indexmanagement.indexstatemanagement.action.ShrinkAction;
import io.lucenia.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.ShrinkStep;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.indexstatemanagement.util.StepUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.cluster.reroute.ClusterRerouteRequest;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.allocation.AllocationCommand;
import io.skylite.core.cluster.routing.allocation.RerouteExplanation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.index.store.StoreStats;
import io.skylite.core.indices.InvalidIndexNameException;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.ShrinkActionProperties;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.routing.allocation.command.MoveAllocationCommand;

public class AttemptMoveShardsStep
extends ShrinkStep {
    public static final String FS_METRIC = "fs";
    public static final String ROUTING_SETTING = "index.routing.allocation.require._name";
    public static final String DEFAULT_TARGET_SUFFIX = "_shrunken";
    public static final String name = "attempt_move_shards_step";
    public static final String UPDATE_FAILED_MESSAGE = "Shrink action failed because shard settings could not be updated.";
    public static final String NO_AVAILABLE_NODES_MESSAGE = "There is no node with enough disk space or shard moving permission for a shrink action.";
    public static final String NO_UNLOCKED_NODES_MESSAGE = "Candidate node for shrink action is locked for other actions. Delaying until gets unlocked.";
    public static final String UNSAFE_FAILURE_MESSAGE = "Shrink failed because index has no replicas and force_unsafe is not set to true.";
    public static final String ONE_PRIMARY_SHARD_MESSAGE = "Source index only has one primary shard. Skip this shrink execution.";
    public static final String NO_SHARD_COUNT_CHANGE_MESSAGE = "Source index already has target number of shards. Skip this shrink execution.";
    public static final String TOO_MANY_DOCS_FAILURE_MESSAGE = "Shrink action failed due to too many documents on each target shard after shrink.";
    public static final String INDEX_NOT_GREEN_MESSAGE = "Shrink action cannot continue as the index is not green.";
    public static final String FAILURE_MESSAGE = "Shrink action failed due to initial moving shards failure.";
    private static final long DEFAULT_LOCK_INTERVAL = 10800L;
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    public static final long THIRTY_SECONDS_IN_MILLIS = 30000L;
    private static final int JOB_INTERVAL_LOCK_MULTIPLIER = 3;
    private static final int LOCK_BUFFER_SECONDS = 1800;
    private static final long MAXIMUM_DOCS_PER_SHARD = 0x80000000L;
    private static final Set<String> ALLOWED_TEMPLATE_FIELDS = Set.of("index", "indexUuid");
    private final ShrinkAction action;

    public AttemptMoveShardsStep(ShrinkAction action) {
        super(name, false, false, false);
        this.action = action;
    }

    @Override
    protected String getGenericFailureMessage() {
        return FAILURE_MESSAGE;
    }

    @Override
    protected void wrappedExecute(StepContext context, ActionListener<Step> listener) {
        Client client = context.getClient();
        String indexName = context.getMetadata().getIndex();
        ClusterHealthRequest healthRequest = new ClusterHealthRequest(new String[]{indexName}).waitForGreenStatus().timeout(TimeValue.timeValueSeconds((long)0L));
        client.admin().cluster().health(healthRequest, ActionListener.wrap(healthResponse -> {
            boolean isGreen;
            boolean bl = isGreen = healthResponse.getStatus() == ClusterHealthStatus.GREEN;
            if (!isGreen) {
                HashMap<String, String> notGreenInfo = new HashMap<String, String>();
                notGreenInfo.put("message", INDEX_NOT_GREEN_MESSAGE);
                this.info = notGreenInfo;
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                listener.onResponse((Object)this);
                return;
            }
            String shrinkTargetIndexName = this.compileTemplate(this.action.getTargetIndexTemplate(), context.getMetadata(), indexName + DEFAULT_TARGET_SUFFIX, context.getScriptService());
            if (this.targetIndexNameIsInvalid(context, shrinkTargetIndexName)) {
                listener.onResponse((Object)this);
                return;
            }
            if (this.shouldFailUnsafe(context, indexName)) {
                listener.onResponse((Object)this);
                return;
            }
            this.getIndexStats(indexName, client, (ActionListener<Tuple<Tuple<StoreStats, DocsStats>, ShardStats[]>>)ActionListener.wrap(statsTriple -> {
                Integer numOriginalShards;
                if (statsTriple == null) {
                    listener.onResponse((Object)this);
                    return;
                }
                StoreStats statsStore = (StoreStats)((Tuple)statsTriple.v1()).v1();
                DocsStats statsDocs = (DocsStats)((Tuple)statsTriple.v1()).v2();
                ShardStats[] shardStats = (ShardStats[])statsTriple.v2();
                long indexSize = statsStore.getSizeInBytes();
                Integer n = numOriginalShards = context.getClusterService().state().metadata().indices().get(indexName) != null ? Integer.valueOf(((IndexMetadata)context.getClusterService().state().metadata().indices().get(indexName)).getNumberOfShards()) : null;
                if (numOriginalShards == null) {
                    throw new IllegalStateException("numOriginalShards should not be null");
                }
                int numTargetShards = this.getNumTargetShards(numOriginalShards, indexSize);
                if (this.shouldFailTooManyDocuments(statsDocs, numTargetShards)) {
                    listener.onResponse((Object)this);
                    return;
                }
                if (numOriginalShards == 1) {
                    HashMap<String, String> onePrimaryInfo = new HashMap<String, String>();
                    onePrimaryInfo.put("message", ONE_PRIMARY_SHARD_MESSAGE);
                    this.info = onePrimaryInfo;
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    listener.onResponse((Object)this);
                    return;
                }
                if (numOriginalShards == numTargetShards) {
                    HashMap<String, String> noChangeInfo = new HashMap<String, String>();
                    noChangeInfo.put("message", NO_SHARD_COUNT_CHANGE_MESSAGE);
                    this.info = noChangeInfo;
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    listener.onResponse((Object)this);
                    return;
                }
                Map<String, String> originalIndexSettings = this.getOriginalSettings(indexName, context);
                this.getJobIntervalSeconds(context.getMetadata().getIndexUuid(), client, (ActionListener<Long>)ActionListenerHelper.wrap(interval -> this.findSuitableNodes(context, shardStats, indexSize, (ActionListener<List<String>>)ActionListenerHelper.wrap(suitableNodes -> {
                    if (suitableNodes.isEmpty()) {
                        HashMap<String, String> noNodesInfo = new HashMap<String, String>();
                        noNodesInfo.put("message", NO_AVAILABLE_NODES_MESSAGE);
                        this.info = noNodesInfo;
                        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                        listener.onResponse((Object)this);
                        return;
                    }
                    this.acquireLockFromNodeList(context, (List<String>)suitableNodes, (Long)interval, indexName, (ActionListener<Tuple<LockModel, String>>)ActionListener.wrap(lockNodePair -> {
                        if (lockNodePair == null) {
                            listener.onResponse((Object)this);
                            return;
                        }
                        LockModel lock = (LockModel)lockNodePair.v1();
                        String nodeName = (String)lockNodePair.v2();
                        this.shrinkActionProperties = new ShrinkActionProperties(nodeName, shrinkTargetIndexName, numTargetShards, lock.getPrimaryTerm(), lock.getSeqNo(), lock.getLockTime().getEpochSecond(), lock.getLockDurationSeconds(), originalIndexSettings);
                        this.setToReadOnlyAndMoveIndexToNode(context, nodeName, lock, (ActionListener<Boolean>)ActionListener.wrap(success -> {
                            if (success.booleanValue()) {
                                HashMap<String, String> successInfo = new HashMap<String, String>();
                                successInfo.put("message", AttemptMoveShardsStep.getSuccessMessage(nodeName));
                                this.info = successInfo;
                                this.stepStatus = Step.StepStatus.COMPLETED;
                            }
                            listener.onResponse((Object)this);
                        }, e -> {
                            this.logger.error("Failed to set readonly and move index to node", (Throwable)e);
                            listener.onFailure(e);
                        }));
                    }, e -> {
                        this.logger.error("Failed to acquire lock from node list", (Throwable)e);
                        listener.onFailure(e);
                    }));
                }, e -> {
                    this.logger.error("Failed to find suitable nodes", (Throwable)e);
                    listener.onFailure(e);
                })), e -> {
                    this.logger.error("Failed to get job interval", (Throwable)e);
                    listener.onFailure(e);
                }));
            }, e -> {
                this.logger.error("Failed to get index stats", (Throwable)e);
                listener.onFailure(e);
            }));
        }, e -> {
            this.logger.error("Failed to check if index is green", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void getIndexStats(String indexName, Client client, ActionListener<Tuple<Tuple<StoreStats, DocsStats>, ShardStats[]>> listener) {
        IndicesStatsRequest statsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{indexName});
        client.admin().indices().stats(statsRequest, ActionListener.wrap(statsResponse -> {
            StoreStats statsStore = statsResponse.getTotal().getStore();
            DocsStats statsDocs = statsResponse.getTotal().getDocs();
            ShardStats[] statsShards = statsResponse.getShards();
            if (statsStore == null || statsDocs == null || statsShards == null) {
                this.setStepFailed(FAILURE_MESSAGE, "Failed to move shards in shrink action as IndicesStatsResponse was missing some stats.", null, null);
                listener.onResponse(null);
                return;
            }
            listener.onResponse((Object)new Tuple((Object)new Tuple((Object)statsStore, (Object)statsDocs), (Object)statsShards));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private Map<String, String> getOriginalSettings(String indexName, StepContext context) {
        String writeBlockSetting;
        Settings indexSettings = context.getClusterService().state().metadata().index(indexName).getSettings();
        HashMap<String, String> originalSettings = new HashMap<String, String>();
        String routingSetting = indexSettings.get(ROUTING_SETTING);
        if (routingSetting != null) {
            originalSettings.put(ROUTING_SETTING, routingSetting);
        }
        if ((writeBlockSetting = indexSettings.get(IndexMetadata.SETTING_BLOCKS_WRITE)) != null) {
            originalSettings.put(IndexMetadata.SETTING_BLOCKS_WRITE, writeBlockSetting);
        }
        return originalSettings;
    }

    private String compileTemplate(Script template, ManagedIndexMetaData managedIndexMetaData, String defaultValue, ScriptService scriptService) {
        Map<String, Object> contextMap;
        if (template == null) {
            return defaultValue;
        }
        try {
            contextMap = LuceniaExtensions.convertToMap((ToXContent)managedIndexMetaData);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert ManagedIndexMetaData to map", e);
        }
        HashMap<String, Object> filteredContext = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : contextMap.entrySet()) {
            if (!ALLOWED_TEMPLATE_FIELDS.contains(entry.getKey())) continue;
            filteredContext.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>(template.getParams());
        params.put("ctx", filteredContext);
        TemplateScript.Factory compiledTemplate = (TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT);
        String compiledValue = compiledTemplate.newInstance(params).execute();
        return compiledValue.isBlank() ? defaultValue : compiledValue;
    }

    private void getJobIntervalSeconds(String indexUuid, Client client, ActionListener<Long> listener) {
        try {
            ManagedIndexConfig managedIndexConfig = ManagedIndexUtils.getManagedIndexConfig(indexUuid, client);
            if (managedIndexConfig == null) {
                listener.onResponse(null);
                return;
            }
            long intervalInSeconds = ManagedIndexUtils.getIntervalFromManagedIndexConfig(managedIndexConfig) / 1000L;
            listener.onResponse((Object)intervalInSeconds);
        }
        catch (Exception e) {
            this.logger.debug("Failed to get managed index config, using default lock interval", (Throwable)e);
            listener.onResponse(null);
        }
    }

    private boolean shouldFailTooManyDocuments(DocsStats docsStats, int numTargetShards) {
        long totalDocs = docsStats.getCount();
        long docsPerTargetShard = totalDocs / (long)numTargetShards;
        if (docsPerTargetShard > 0x80000000L) {
            this.setStepFailed(TOO_MANY_DOCS_FAILURE_MESSAGE, TOO_MANY_DOCS_FAILURE_MESSAGE, null, null);
            return true;
        }
        return false;
    }

    private boolean shouldFailUnsafe(StepContext context, String indexName) {
        boolean shouldFailForceUnsafeCheck;
        if (this.action.getForceUnsafe() != null && this.action.getForceUnsafe().booleanValue()) {
            return false;
        }
        Integer numReplicas = context.getClusterService().state().metadata().indices().get(indexName) != null ? Integer.valueOf(((IndexMetadata)context.getClusterService().state().metadata().indices().get(indexName)).getNumberOfReplicas()) : null;
        boolean bl = shouldFailForceUnsafeCheck = numReplicas != null && numReplicas == 0;
        if (shouldFailForceUnsafeCheck) {
            this.logger.info(UNSAFE_FAILURE_MESSAGE);
            this.setStepFailed(UNSAFE_FAILURE_MESSAGE, null, null, null);
            return true;
        }
        return false;
    }

    private boolean targetIndexNameIsInvalid(StepContext context, String shrinkTargetIndexName) {
        boolean indexExists = context.getClusterService().state().metadata().indices().containsKey(shrinkTargetIndexName);
        if (indexExists) {
            String indexExistsMessage = AttemptMoveShardsStep.getIndexExistsMessage(shrinkTargetIndexName);
            this.setStepFailed(indexExistsMessage, indexExistsMessage, null, null);
            return true;
        }
        try {
            MetadataCreateIndexService.validateIndexOrAliasName((String)shrinkTargetIndexName, InvalidIndexNameException::new);
        }
        catch (Exception e) {
            this.setStepFailed(e.getMessage(), e.getMessage(), null, e);
            return true;
        }
        return false;
    }

    private void setToReadOnlyAndMoveIndexToNode(StepContext stepContext, String node, LockModel lock, ActionListener<Boolean> listener) {
        Settings updateSettings = Settings.builder().put(IndexMetadata.SETTING_BLOCKS_WRITE, true).put(ROUTING_SETTING, node).build();
        UpdateSettingsRequest updateRequest = new UpdateSettingsRequest(updateSettings, new String[]{stepContext.getMetadata().getIndex()});
        stepContext.getClient().admin().indices().updateSettings(updateRequest, ActionListener.wrap(response -> {
            boolean isUpdateAcknowledged;
            boolean bl = isUpdateAcknowledged = response != null && response.isAcknowledged();
            if (!isUpdateAcknowledged) {
                this.setStepFailed(UPDATE_FAILED_MESSAGE, UPDATE_FAILED_MESSAGE, null, null);
                stepContext.getLockService().release(lock, ActionListener.wrap(released -> {
                    if (!released.booleanValue()) {
                        this.logger.error("Failed to release Shrink action lock on node: [{}]", (Object)node);
                    }
                    listener.onResponse((Object)false);
                }, e -> {
                    this.logger.error("Failed to release Shrink action lock on node: [" + node + "]", (Throwable)e);
                    listener.onResponse((Object)false);
                }));
            } else {
                listener.onResponse((Object)true);
            }
        }, e -> {
            this.logger.error("Failed to update settings", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void acquireLockFromNodeList(StepContext context, List<String> suitableNodes, Long jobIntervalSeconds, String indexName, ActionListener<Tuple<LockModel, String>> listener) {
        this.acquireLockFromNodeListRecursive(context, suitableNodes, 0, jobIntervalSeconds, indexName, listener);
    }

    private void acquireLockFromNodeListRecursive(StepContext context, List<String> suitableNodes, int index, Long jobIntervalSeconds, String indexName, ActionListener<Tuple<LockModel, String>> listener) {
        if (index >= suitableNodes.size()) {
            HashMap<String, String> noLockInfo = new HashMap<String, String>();
            noLockInfo.put("message", NO_UNLOCKED_NODES_MESSAGE);
            this.info = noLockInfo;
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            listener.onResponse(null);
            return;
        }
        String nodeName = suitableNodes.get(index);
        String lockID = StepUtils.getShrinkJobID(nodeName);
        context.getLockService().acquireLockWithId(".opendistro-ism-config", Long.valueOf(AttemptMoveShardsStep.getShrinkLockDuration(jobIntervalSeconds)), lockID, ActionListener.wrap(lock -> {
            if (lock != null) {
                listener.onResponse((Object)new Tuple(lock, (Object)nodeName));
            } else {
                this.logger.info("Shrink action could not acquire lock of node [{}] for [{}].", (Object)nodeName, (Object)indexName);
                this.acquireLockFromNodeListRecursive(context, suitableNodes, index + 1, jobIntervalSeconds, indexName, listener);
            }
        }, e -> {
            this.logger.error("Failed to acquire lock for node [" + nodeName + "]", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void findSuitableNodes(StepContext stepContext, ShardStats[] shardStats, long indexSizeInBytes, ActionListener<List<String>> listener) {
        NodesStatsRequest nodesStatsReq = new NodesStatsRequest().addMetric(FS_METRIC);
        stepContext.getClient().admin().cluster().nodesStats(nodesStatsReq, ActionListener.wrap(nodeStatsResponse -> {
            ArrayList<NodeStats> nodesList = new ArrayList<NodeStats>();
            for (NodeStats nodeStats : nodeStatsResponse.getNodes()) {
                if (!nodeStats.getNode().isDataNode()) continue;
                nodesList.add(nodeStats);
            }
            ArrayList<String> suitableNodes = new ArrayList<String>();
            Comparator<Tuple> comparator = Comparator.comparing(Tuple::v1);
            PriorityQueue<Tuple<Long, String>> nodesWithSpace = new PriorityQueue<Tuple<Long, String>>(comparator);
            for (NodeStats node : nodesList) {
                long remainingDiskSpace = StepUtils.getNodeFreeDiskSpaceAfterShrink(node, indexSizeInBytes, stepContext.getClusterService().getClusterSettings());
                if (remainingDiskSpace <= 0L) continue;
                nodesWithSpace.add((Tuple<Long, String>)new Tuple((Object)remainingDiskSpace, (Object)node.getNode().getName()));
            }
            if (nodesWithSpace.size() < 1) {
                this.logger.info("No node has enough disk space for shrink action.");
                listener.onResponse(suitableNodes);
                return;
            }
            Map<Integer, Set<String>> shardIdToNodeList = StepUtils.getShardIdToNodeNameSet(shardStats, stepContext.getClusterService().state().nodes());
            this.checkNodesForShardMovingPermission(stepContext, shardStats, nodesWithSpace, shardIdToNodeList, suitableNodes, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkNodesForShardMovingPermission(StepContext stepContext, ShardStats[] shardStats, PriorityQueue<Tuple<Long, String>> nodesWithSpace, Map<Integer, Set<String>> shardIdToNodeList, List<String> suitableNodes, ActionListener<List<String>> listener) {
        this.checkNextNodeForShardMovingPermission(stepContext, shardStats, nodesWithSpace, shardIdToNodeList, suitableNodes, listener);
    }

    private void checkNextNodeForShardMovingPermission(StepContext stepContext, ShardStats[] shardStats, PriorityQueue<Tuple<Long, String>> nodesWithSpace, Map<Integer, Set<String>> shardIdToNodeList, List<String> suitableNodes, ActionListener<List<String>> listener) {
        if (nodesWithSpace.isEmpty()) {
            if (suitableNodes.size() < 1) {
                this.logger.info("No node has shard moving permission for shrink action.");
            }
            listener.onResponse(suitableNodes);
            return;
        }
        Tuple<Long, String> sizeNodeTuple = nodesWithSpace.poll();
        String targetNodeName = (String)sizeNodeTuple.v2();
        String indexName = stepContext.getMetadata().getIndex();
        ClusterRerouteRequest clusterRerouteRequest = new ClusterRerouteRequest().explain(true).dryRun(true);
        HashSet<Integer> requestedShardIds = new HashSet<Integer>();
        for (ShardStats shard : shardStats) {
            int shardId = shard.getShardRouting().shardId().id();
            String currentShardNode = stepContext.getClusterService().state().nodes().get(shard.getShardRouting().currentNodeId()).getName();
            Set<String> nodesWithThisShard = shardIdToNodeList.get(shardId);
            if (nodesWithThisShard != null && nodesWithThisShard.contains(targetNodeName) || requestedShardIds.contains(shardId)) continue;
            clusterRerouteRequest.add(new AllocationCommand[]{new MoveAllocationCommand(indexName, shardId, currentShardNode, targetNodeName)});
            requestedShardIds.add(shardId);
        }
        stepContext.getClient().admin().cluster().reroute(clusterRerouteRequest, ActionListener.wrap(clusterRerouteResponse -> {
            int numOfDecisions = clusterRerouteResponse.getExplanations().explanations().size();
            int numNoDecisions = 0;
            int numYesDecisions = 0;
            int numThrottleDecisions = 0;
            for (int i = 0; i < clusterRerouteResponse.getExplanations().explanations().size(); ++i) {
                Decision.Type type = ((RerouteExplanation)clusterRerouteResponse.getExplanations().explanations().get(i)).decisions().type();
                if (type.equals((Object)Decision.Type.NO)) {
                    ++numNoDecisions;
                    continue;
                }
                if (type.equals((Object)Decision.Type.YES)) {
                    ++numYesDecisions;
                    continue;
                }
                if (!type.equals((Object)Decision.Type.THROTTLE)) continue;
                ++numThrottleDecisions;
            }
            this.logger.debug(AttemptMoveShardsStep.getShardMovingDecisionInfo(numNoDecisions, numYesDecisions, numThrottleDecisions, targetNodeName));
            if (numOfDecisions - numNoDecisions >= requestedShardIds.size()) {
                suitableNodes.add((String)sizeNodeTuple.v2());
            }
            this.checkNextNodeForShardMovingPermission(stepContext, shardStats, nodesWithSpace, shardIdToNodeList, suitableNodes, listener);
        }, e -> {
            this.logger.error("Failed to check shard moving permission", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private int getNumTargetShards(int numOriginalShards, long indexSize) {
        if (this.action.getNumNewShards() != null) {
            return this.getGreatestFactorLessThan(numOriginalShards, this.action.getNumNewShards());
        }
        if (this.action.getPercentageOfSourceShards() != null) {
            int numTargetShards = (int)Math.floor(this.action.getPercentageOfSourceShards() * (double)numOriginalShards);
            return this.getGreatestFactorLessThan(numOriginalShards, numTargetShards);
        }
        if (this.action.getMaxShardSize() != null) {
            long maxShardSizeInBytes = this.action.getMaxShardSize().getBytes();
            int minNumTargetShards = (int)Math.ceil((double)indexSize / (double)maxShardSizeInBytes);
            return this.getMinFactorGreaterThan(numOriginalShards, minNumTargetShards);
        }
        return numOriginalShards;
    }

    private int getGreatestFactorLessThan(int n, int k) {
        if (k >= n) {
            return n;
        }
        int bound = Math.min((int)Math.floor(Math.sqrt(n)), k);
        int greatestFactor = 1;
        for (int i = 2; i <= bound; ++i) {
            if (n % i != 0) continue;
            int complement = n / i;
            if (complement <= k) {
                return complement;
            }
            greatestFactor = i;
        }
        return greatestFactor;
    }

    private int getMinFactorGreaterThan(int n, int k) {
        if (k >= n) {
            return n;
        }
        for (int i = k; i <= n; ++i) {
            if (n % i != 0) continue;
            return i;
        }
        return n;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        StepMetaData stepMetaData = this.info != null && ONE_PRIMARY_SHARD_MESSAGE.equals(this.info.get("message")) ? new StepMetaData("wait_for_shrink_step", this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus) : new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(currentMetadata.getActionMetaData() != null ? new ActionMetaData.Builder(currentMetadata.getActionMetaData()).actionProperties(new ActionProperties(null, null, null, null, this.shrinkActionProperties, null)).build() : null).stepMetaData(stepMetaData).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getSuccessMessage(String node) {
        return "Successfully initialized moving the shards to " + node + " for a shrink action.";
    }

    public static String getIndexExistsMessage(String newIndex) {
        return "Shrink failed because " + newIndex + " already exists.";
    }

    public static String getShardMovingDecisionInfo(int noCount, int yesCount, int throttleCount, String node) {
        return "Shard moving decisions on node " + node + ", NO: " + noCount + ", YES: " + yesCount + ", THROTTLE: " + throttleCount + ".";
    }

    private static long getShrinkLockDuration(Long jobInterval) {
        if (jobInterval != null) {
            return jobInterval * 3L + 1800L;
        }
        return 10800L;
    }
}

