/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.shrink;

import io.lucenia.indexmanagement.indexstatemanagement.action.ShrinkAction;
import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.ShrinkStep;
import io.lucenia.indexmanagement.indexstatemanagement.util.StepUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.action.admin.indices.shrink.ResizeRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.index.store.StoreStats;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.ShrinkActionProperties;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;

public class AttemptShrinkStep
extends ShrinkStep {
    public static final String name = "attempt_shrink_step";
    public static final String FAILURE_MESSAGE = "Shrink failed when sending shrink request.";
    public static final String WRITE_BLOCK_FAILED_MESSAGE = "Failed to set write block before sending shrink request.";
    public static final String NOT_ENOUGH_SPACE_FAILURE_MESSAGE = "Shrink failed as the selected node no longer had enough free space to shrink to.";
    public static final String INDEX_HEALTH_NOT_GREEN_MESSAGE = "Shrink delayed because index health is not green.";
    private final ShrinkAction action;

    public AttemptShrinkStep(ShrinkAction action) {
        super(name, true, true, false);
        this.action = action;
    }

    @Override
    protected String getGenericFailureMessage() {
        return FAILURE_MESSAGE;
    }

    @Override
    protected void wrappedExecute(StepContext context, ActionListener<Step> listener) {
        String indexName = context.getMetadata().getIndex();
        this.checkShrinkActionPropertiesAndRenewLock(context, (ActionListener<ShrinkActionProperties>)ActionListener.wrap(localShrinkActionProperties -> {
            if (localShrinkActionProperties == null) {
                listener.onResponse((Object)this);
                return;
            }
            ClusterHealthRequest healthRequest = new ClusterHealthRequest(new String[]{indexName}).waitForGreenStatus().timeout(TimeValue.timeValueSeconds((long)0L));
            context.getClient().admin().cluster().health(healthRequest, ActionListener.wrap(healthResponse -> {
                boolean isGreen;
                boolean bl = isGreen = healthResponse.getStatus() == ClusterHealthStatus.GREEN;
                if (!isGreen) {
                    this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                    HashMap<String, String> conditionInfo = new HashMap<String, String>();
                    conditionInfo.put("message", INDEX_HEALTH_NOT_GREEN_MESSAGE);
                    this.info = conditionInfo;
                    listener.onResponse((Object)this);
                    return;
                }
                this.isNodeStillSuitable(localShrinkActionProperties.getNodeName(), indexName, context, (ActionListener<Boolean>)ActionListener.wrap(isSuitable -> {
                    if (!isSuitable.booleanValue()) {
                        listener.onResponse((Object)this);
                        return;
                    }
                    this.confirmIndexWriteBlock(context, indexName, (ActionListener<Boolean>)ActionListener.wrap(writeBlockConfirmed -> {
                        if (!writeBlockConfirmed.booleanValue()) {
                            listener.onResponse((Object)this);
                            return;
                        }
                        this.resizeIndex(indexName, (ShrinkActionProperties)localShrinkActionProperties, context, (ActionListener<Boolean>)ActionListener.wrap(resizeSuccess -> {
                            if (!resizeSuccess.booleanValue()) {
                                listener.onResponse((Object)this);
                                return;
                            }
                            HashMap<String, String> successInfo = new HashMap<String, String>();
                            successInfo.put("message", AttemptShrinkStep.getSuccessMessage(localShrinkActionProperties.getTargetIndexName()));
                            this.info = successInfo;
                            this.stepStatus = Step.StepStatus.COMPLETED;
                            listener.onResponse((Object)this);
                        }, e -> {
                            this.logger.error("Failed to resize index", (Throwable)e);
                            listener.onFailure(e);
                        }));
                    }, e -> {
                        this.logger.error("Failed to confirm write block", (Throwable)e);
                        listener.onFailure(e);
                    }));
                }, e -> {
                    this.logger.error("Failed to check if node is still suitable", (Throwable)e);
                    listener.onFailure(e);
                }));
            }, e -> {
                this.logger.error("Failed to check if index is green", (Throwable)e);
                listener.onFailure(e);
            }));
        }, e -> {
            this.logger.error("Failed to check shrink action properties and renew lock", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void isNodeStillSuitable(String nodeName, String indexName, StepContext context, final ActionListener<Boolean> listener) {
        IndicesStatsRequest statsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{indexName});
        context.getClient().admin().indices().stats(statsRequest, ActionListener.wrap(statsResponse -> {
            StoreStats statsStore = statsResponse.getTotal().getStore();
            if (statsStore == null) {
                this.cleanupAndFail(FAILURE_MESSAGE, "Shrink action failed as indices stats request was missing store stats.", null, null, new ActionListener<Step>(){

                    public void onResponse(Step step) {
                        listener.onResponse((Object)false);
                    }

                    public void onFailure(Exception e) {
                        listener.onResponse((Object)false);
                    }
                });
                return;
            }
            long indexSizeInBytes = statsStore.getSizeInBytes();
            NodesStatsRequest nodesStatsReq = new NodesStatsRequest().addMetric("fs");
            context.getClient().admin().cluster().nodesStats(nodesStatsReq, ActionListener.wrap(nodeStatsResponse -> {
                NodeStats node = null;
                for (NodeStats ns : nodeStatsResponse.getNodes()) {
                    if (!ns.getNode().getName().equals(nodeName)) continue;
                    node = ns;
                    break;
                }
                if (node == null) {
                    this.cleanupAndFail(FAILURE_MESSAGE, "Shrink action failed as node stats were missing the previously selected node.", null, null, new ActionListener<Step>(){

                        public void onResponse(Step step) {
                            listener.onResponse((Object)false);
                        }

                        public void onFailure(Exception e) {
                            listener.onResponse((Object)false);
                        }
                    });
                    return;
                }
                long remainingMem = StepUtils.getNodeFreeDiskSpaceAfterShrink(node, indexSizeInBytes, context.getClusterService().getClusterSettings());
                if (remainingMem < 1L) {
                    this.cleanupAndFail(NOT_ENOUGH_SPACE_FAILURE_MESSAGE, NOT_ENOUGH_SPACE_FAILURE_MESSAGE, null, null, new ActionListener<Step>(){

                        public void onResponse(Step step) {
                            listener.onResponse((Object)false);
                        }

                        public void onFailure(Exception e) {
                            listener.onResponse((Object)false);
                        }
                    });
                    return;
                }
                listener.onResponse((Object)true);
            }, e -> {
                this.logger.error("Failed to get node stats", (Throwable)e);
                listener.onFailure(e);
            }));
        }, e -> {
            this.logger.error("Failed to get index stats", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void confirmIndexWriteBlock(StepContext stepContext, String indexName, final ActionListener<Boolean> listener) {
        Settings updateSettings = Settings.builder().put(IndexMetadata.SETTING_BLOCKS_WRITE, true).build();
        UpdateSettingsRequest updateRequest = new UpdateSettingsRequest(updateSettings, new String[]{stepContext.getMetadata().getIndex()});
        stepContext.getClient().admin().indices().updateSettings(updateRequest, ActionListener.wrap(response -> {
            boolean isUpdateAcknowledged;
            boolean bl = isUpdateAcknowledged = response != null && response.isAcknowledged();
            if (!isUpdateAcknowledged) {
                this.cleanupAndFail(WRITE_BLOCK_FAILED_MESSAGE, "Failed to confirm write block for index: [" + indexName + "] before sending shrink request.", null, null, new ActionListener<Step>(){

                    public void onResponse(Step step) {
                        listener.onResponse((Object)false);
                    }

                    public void onFailure(Exception e) {
                        listener.onResponse((Object)false);
                    }
                });
            } else {
                listener.onResponse((Object)true);
            }
        }, e -> {
            this.logger.error("Failed to update settings", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void resizeIndex(String sourceIndex, ShrinkActionProperties shrinkActionProperties, StepContext context, final ActionListener<Boolean> listener) {
        String targetIndex = shrinkActionProperties.getTargetIndexName();
        ResizeRequest req = new ResizeRequest(targetIndex, sourceIndex);
        req.getTargetIndexRequest().settings(Settings.builder().put("index.routing.allocation.require._name", shrinkActionProperties.getNodeName()).put("index.number_of_shards", shrinkActionProperties.getTargetNumShards()).build());
        if (this.action.getAliases() != null) {
            this.action.getAliases().forEach(alias -> req.getTargetIndexRequest().alias(alias));
        }
        context.getClient().admin().indices().resizeIndex(req, ActionListener.wrap(resizeResponse -> {
            if (!resizeResponse.isAcknowledged()) {
                this.cleanupAndFail(FAILURE_MESSAGE, "Shrink action failed as the resize index request was not acknowledged.", null, null, new ActionListener<Step>(){

                    public void onResponse(Step step) {
                        listener.onResponse((Object)false);
                    }

                    public void onFailure(Exception e) {
                        listener.onResponse((Object)false);
                    }
                });
                return;
            }
            listener.onResponse((Object)true);
        }, e -> {
            this.logger.error("Failed to resize index", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public boolean isIdempotent() {
        return false;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(currentMetadata.getActionMetaData() != null ? new ActionMetaData.Builder(currentMetadata.getActionMetaData()).actionProperties(new ActionProperties(null, null, null, null, this.shrinkActionProperties, null)).build() : null).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public static String getSuccessMessage(String newIndex) {
        return "Shrink started. " + newIndex + " currently being populated.";
    }
}

