/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.shrink;

import io.lucenia.indexmanagement.indexstatemanagement.action.ShrinkAction;
import io.lucenia.indexmanagement.indexstatemanagement.util.StepUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.delete.DeleteIndexRequest;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ShrinkActionProperties;
import io.skylite.indexmanagement.model.StepContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ShrinkStep
extends Step {
    protected final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    protected Map<String, Object> info = null;
    protected ShrinkActionProperties shrinkActionProperties = null;
    private final boolean cleanupSettings;
    private final boolean cleanupLock;
    private final boolean cleanupTargetIndex;
    public static final String METADATA_FAILURE_MESSAGE = "Shrink action properties are null, metadata was not properly populated";

    protected ShrinkStep(String name, boolean cleanupSettings, boolean cleanupLock, boolean cleanupTargetIndex) {
        super(name);
        this.cleanupSettings = cleanupSettings;
        this.cleanupLock = cleanupLock;
        this.cleanupTargetIndex = cleanupTargetIndex;
    }

    public CompletableFuture<Step> execute() {
        final CompletableFuture<Step> future = new CompletableFuture<Step>();
        StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        ActionListener<Step> listener = new ActionListener<Step>(){

            public void onResponse(Step step) {
                future.complete(step);
            }

            public void onFailure(Exception e) {
                if (e instanceof SkyliteSecurityException) {
                    String securityFailureMessage = ShrinkAction.getSecurityFailureMessage(e.getLocalizedMessage());
                    ShrinkStep.this.cleanupAndFail(securityFailureMessage, securityFailureMessage, e.getMessage(), e, this);
                } else if (e instanceof RemoteTransportException) {
                    Exception unwrappedException = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e);
                    ShrinkStep.this.cleanupAndFail(ShrinkStep.this.getGenericFailureMessage(), ShrinkStep.this.getGenericFailureMessage(), e.getMessage(), unwrappedException, this);
                } else {
                    ShrinkStep.this.cleanupAndFail(ShrinkStep.this.getGenericFailureMessage(), ShrinkStep.this.getGenericFailureMessage(), e.getMessage(), e, this);
                }
            }
        };
        try {
            this.wrappedExecute(context, listener);
        }
        catch (SkyliteSecurityException e) {
            String securityFailureMessage = ShrinkAction.getSecurityFailureMessage(e.getLocalizedMessage());
            this.cleanupAndFail(securityFailureMessage, securityFailureMessage, e.getMessage(), (Exception)((Object)e), listener);
        }
        catch (RemoteTransportException e) {
            Exception unwrappedException = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e);
            this.cleanupAndFail(this.getGenericFailureMessage(), this.getGenericFailureMessage(), e.getMessage(), unwrappedException, listener);
        }
        catch (Exception e) {
            this.cleanupAndFail(this.getGenericFailureMessage(), this.getGenericFailureMessage(), e.getMessage(), e, listener);
        }
        return future;
    }

    protected void cleanupAndFail(final String infoMessage, final String logMessage, final String cause, final Exception e, final ActionListener<Step> listener) {
        this.cleanupResources(this.cleanupSettings, this.cleanupLock, this.cleanupTargetIndex, new ActionListener<Void>(){

            public void onResponse(Void unused) {
                ShrinkStep.this.setStepFailed(infoMessage, logMessage, cause, e);
                listener.onResponse((Object)ShrinkStep.this);
            }

            public void onFailure(Exception ex) {
                ShrinkStep.this.setStepFailed(infoMessage, logMessage, cause, e);
                listener.onResponse((Object)ShrinkStep.this);
            }
        });
    }

    protected abstract String getGenericFailureMessage();

    protected abstract void wrappedExecute(StepContext var1, ActionListener<Step> var2);

    protected void checkShrinkActionPropertiesAndRenewLock(StepContext context, final ActionListener<ShrinkActionProperties> listener) {
        ShrinkActionProperties localShrinkActionProperties;
        ShrinkActionProperties shrinkActionProperties = localShrinkActionProperties = context.getMetadata().getActionMetaData() != null && context.getMetadata().getActionMetaData().getActionProperties() != null ? context.getMetadata().getActionMetaData().getActionProperties().getShrinkActionProperties() : null;
        if (localShrinkActionProperties == null) {
            this.setStepFailed(METADATA_FAILURE_MESSAGE, METADATA_FAILURE_MESSAGE, null, null);
            listener.onResponse(null);
            return;
        }
        StepUtils.renewShrinkLock(localShrinkActionProperties, context.getLockService(), this.logger, (ActionListener<LockModel>)ActionListener.wrap(lock -> {
            ShrinkActionProperties updatedProperties;
            if (lock == null) {
                this.cleanupAndFail("Failed to renew lock on node [" + localShrinkActionProperties.getNodeName() + "]", "Shrink action failed to renew lock on node [" + localShrinkActionProperties.getNodeName() + "]", null, null, new ActionListener<Step>(){

                    public void onResponse(Step step) {
                        listener.onResponse(null);
                    }

                    public void onFailure(Exception e) {
                        listener.onResponse(null);
                    }
                });
                return;
            }
            this.shrinkActionProperties = updatedProperties = StepUtils.getUpdatedShrinkActionProperties(localShrinkActionProperties, lock);
            listener.onResponse((Object)updatedProperties);
        }, e -> {
            this.logger.error("Failed to renew lock", (Throwable)e);
            listener.onResponse(null);
        }));
    }

    protected void setStepFailed(String infoMessage, String logMessage, String cause, Exception e) {
        if (logMessage != null) {
            if (e != null) {
                this.logger.error(logMessage, (Throwable)e);
            } else {
                this.logger.error(logMessage);
            }
        }
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", infoMessage);
        if (cause != null) {
            mutableInfo.put("cause", cause);
        }
        this.info = mutableInfo;
        this.stepStatus = Step.StepStatus.FAILED;
    }

    protected void cleanupResources(boolean resetSettings, final boolean releaseLock, final boolean deleteTargetIndex, final ActionListener<Void> listener) {
        if (this.shrinkActionProperties == null) {
            this.logger.error("Shrink action failed to clean up resources due to null shrink action properties.");
            listener.onResponse(null);
            return;
        }
        if (resetSettings) {
            this.resetIndexSettings(this.shrinkActionProperties, new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    ShrinkStep.this.continueCleanup(releaseLock, deleteTargetIndex, (ActionListener<Void>)listener);
                }

                public void onFailure(Exception e) {
                    ShrinkStep.this.continueCleanup(releaseLock, deleteTargetIndex, (ActionListener<Void>)listener);
                }
            });
        } else {
            this.continueCleanup(releaseLock, deleteTargetIndex, listener);
        }
    }

    private void continueCleanup(final boolean releaseLock, boolean deleteTargetIndex, final ActionListener<Void> listener) {
        if (deleteTargetIndex) {
            this.deleteTargetIndex(this.shrinkActionProperties, new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    if (releaseLock) {
                        ShrinkStep.this.releaseLock(ShrinkStep.this.shrinkActionProperties, (ActionListener<Void>)listener);
                    } else {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception e) {
                    if (releaseLock) {
                        ShrinkStep.this.releaseLock(ShrinkStep.this.shrinkActionProperties, (ActionListener<Void>)listener);
                    } else {
                        listener.onResponse(null);
                    }
                }
            });
        } else if (releaseLock) {
            this.releaseLock(this.shrinkActionProperties, listener);
        } else {
            this.shrinkActionProperties = null;
            listener.onResponse(null);
        }
    }

    private void resetIndexSettings(ShrinkActionProperties shrinkActionProperties, ActionListener<Void> listener) {
        Map originalIndexSettings = shrinkActionProperties.getOriginalIndexSettings();
        String indexName = this.getContext() != null ? this.getContext().getMetadata().getIndex() : null;
        try {
            if (indexName != null && this.getContext() != null) {
                StepUtils.resetReadOnlyAndRouting(indexName, this.getContext().getClient(), originalIndexSettings, (ActionListener<Boolean>)ActionListener.wrap(success -> {
                    if (!success.booleanValue()) {
                        this.logger.error("Shrink action failed to reset index settings on [" + indexName + "]");
                    }
                    listener.onResponse(null);
                }, e -> {
                    this.logger.error("Shrink action failed while trying to clean up routing and readonly setting on [" + indexName + "]", (Throwable)e);
                    listener.onResponse(null);
                }));
            } else {
                this.logger.error("Shrink action failed to reset index settings on [" + indexName + "] due to uninitialized metadata values.");
                listener.onResponse(null);
            }
        }
        catch (Exception e2) {
            this.logger.error("Shrink action failed while trying to clean up routing and readonly setting on [" + indexName + "]", (Throwable)e2);
            listener.onResponse(null);
        }
    }

    private void deleteTargetIndex(ShrinkActionProperties shrinkActionProperties, ActionListener<Void> listener) {
        String targetIndexName = shrinkActionProperties.getTargetIndexName();
        try {
            if (this.getContext() != null && this.getContext().getClient() != null) {
                this.getContext().getClient().threadPool().getThreadContext().stashContext().close();
                DeleteIndexRequest deleteRequest = new DeleteIndexRequest(targetIndexName);
                this.getContext().getClient().admin().indices().delete(deleteRequest, ActionListener.wrap(response -> {
                    if (!response.isAcknowledged()) {
                        this.logger.error("Shrink action failed to delete target index [" + targetIndexName + "] during cleanup after a failure");
                    }
                    listener.onResponse(null);
                }, e -> {
                    this.logger.error("Shrink action failed while trying to delete the target index [" + targetIndexName + "] after a failure", (Throwable)e);
                    listener.onResponse(null);
                }));
            } else {
                this.logger.error("Shrink action failed to delete target index [" + targetIndexName + "] after a failure due to a null client in the step context");
                listener.onResponse(null);
            }
        }
        catch (Exception e2) {
            this.logger.error("Shrink action failed while trying to delete the target index [" + targetIndexName + "] after a failure", (Throwable)e2);
            listener.onResponse(null);
        }
    }

    private void releaseLock(ShrinkActionProperties shrinkActionProperties, ActionListener<Void> listener) {
        try {
            if (this.getContext() != null && this.getContext().getLockService() != null) {
                StepUtils.releaseShrinkLock(shrinkActionProperties, this.getContext().getLockService(), (ActionListener<Boolean>)ActionListener.wrap(released -> {
                    if (!released.booleanValue()) {
                        this.logger.error("Failed to release Shrink action lock on node [" + shrinkActionProperties.getNodeName() + "]");
                    }
                    this.shrinkActionProperties = null;
                    listener.onResponse(null);
                }, e -> {
                    this.logger.error("Failed to release Shrink action lock on node [" + shrinkActionProperties.getNodeName() + "]", (Throwable)e);
                    this.shrinkActionProperties = null;
                    listener.onResponse(null);
                }));
            } else {
                this.logger.error("Shrink action failed to release lock on node [" + shrinkActionProperties.getNodeName() + "] due to uninitialized metadata values.");
                this.shrinkActionProperties = null;
                listener.onResponse(null);
            }
        }
        catch (Exception e2) {
            this.logger.error("Failed to release Shrink action lock on node [" + shrinkActionProperties.getNodeName() + "]", (Throwable)e2);
            this.shrinkActionProperties = null;
            listener.onResponse(null);
        }
    }
}

