/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.shrink;

import io.lucenia.indexmanagement.indexstatemanagement.action.ShrinkAction;
import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.ShrinkStep;
import io.lucenia.indexmanagement.indexstatemanagement.util.StepUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.ShrinkActionProperties;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WaitForMoveShardsStep
extends ShrinkStep {
    public static final String name = "wait_for_move_shards_step";
    public static final String FAILURE_MESSAGE = "Shrink failed when waiting for shards to move.";
    public static final long MOVE_SHARDS_TIMEOUT_IN_SECONDS = 43200L;
    private final ShrinkAction action;

    public WaitForMoveShardsStep(ShrinkAction action) {
        super(name, true, true, false);
        this.action = action;
    }

    @Override
    protected String getGenericFailureMessage() {
        return FAILURE_MESSAGE;
    }

    @Override
    protected void wrappedExecute(StepContext context, ActionListener<Step> listener) {
        String indexName = context.getMetadata().getIndex();
        this.checkShrinkActionPropertiesAndRenewLock(context, (ActionListener<ShrinkActionProperties>)ActionListener.wrap(localShrinkActionProperties -> {
            if (localShrinkActionProperties == null) {
                listener.onResponse((Object)this);
                return;
            }
            this.getShardStats(indexName, context.getClient(), (ActionListener<ShardStats[]>)ActionListener.wrap(shardStats -> {
                if (shardStats == null) {
                    listener.onResponse((Object)this);
                    return;
                }
                int numShardsInSync = this.getNumShardsInSync((ShardStats[])shardStats, context.getClusterService().state(), indexName);
                String nodeToMoveOnto = localShrinkActionProperties.getNodeName();
                int numShardsOnNode = this.getNumShardsWithCopyOnNode((ShardStats[])shardStats, context.getClusterService().state(), nodeToMoveOnto);
                Integer numPrimaryShards = ((IndexMetadata)context.getClusterService().state().metadata().indices().get(indexName)).getNumberOfShards();
                if (numPrimaryShards == null) {
                    throw new IllegalStateException("numberOfShards should not be null");
                }
                if (numShardsOnNode >= numPrimaryShards && numShardsInSync >= numPrimaryShards) {
                    HashMap<String, String> successInfo = new HashMap<String, String>();
                    successInfo.put("message", WaitForMoveShardsStep.getSuccessMessage(nodeToMoveOnto));
                    this.info = successInfo;
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    listener.onResponse((Object)this);
                } else {
                    int numShardsNotOnNode = numPrimaryShards - numShardsOnNode;
                    int numShardsNotInSync = numPrimaryShards - numShardsInSync;
                    this.checkTimeOut(context, numShardsNotOnNode, numShardsNotInSync, nodeToMoveOnto, listener);
                }
            }, e -> {
                this.logger.error("Failed to get shard stats", (Throwable)e);
                listener.onFailure(e);
            }));
        }, e -> {
            this.logger.error("Failed to check shrink action properties and renew lock", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private int getNumShardsInSync(ShardStats[] shardStats, ClusterState state, String indexName) {
        Integer numReplicas = ((IndexMetadata)state.metadata().indices().get(indexName)).getNumberOfReplicas();
        if (numReplicas == null) {
            throw new IllegalStateException("numberOfReplicas should not be null");
        }
        Map inSyncAllocations = ((IndexMetadata)state.metadata().indices().get(indexName)).getInSyncAllocationIds();
        int numShardsInSync = 0;
        for (ShardStats shard : shardStats) {
            Set inSyncSet;
            if (!shard.getShardRouting().primary() || (inSyncSet = (Set)inSyncAllocations.get(shard.getShardRouting().id())) == null || inSyncSet.size() != numReplicas + 1) continue;
            ++numShardsInSync;
        }
        return numShardsInSync;
    }

    private int getNumShardsWithCopyOnNode(ShardStats[] shardStats, ClusterState clusterState, String nodeToMoveOnto) {
        HashMap<Integer, Boolean> shardIdStartedOnNode = new HashMap<Integer, Boolean>();
        for (ShardStats shard : shardStats) {
            String nodeName;
            int shardId = shard.getShardRouting().shardId().id();
            if (Boolean.TRUE.equals(shardIdStartedOnNode.get(shardId)) || (nodeName = clusterState.nodes().get(shard.getShardRouting().currentNodeId()).getName()) == null) continue;
            shardIdStartedOnNode.put(shardId, nodeName.equals(nodeToMoveOnto) && shard.getShardRouting().started());
        }
        return (int)shardIdStartedOnNode.values().stream().filter(Boolean::booleanValue).count();
    }

    private void getShardStats(String indexName, Client client, final ActionListener<ShardStats[]> listener) {
        IndicesStatsRequest indexStatsRequests = (IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{indexName});
        client.admin().indices().stats(indexStatsRequests, ActionListener.wrap(response -> {
            ShardStats[] shardStats = response.getShards();
            if (shardStats == null) {
                this.cleanupAndFail("Shrink action failed due to initial moving shards failure.", "Failed to move shards in shrink action as shard stats were null.", null, null, new ActionListener<Step>(){

                    public void onResponse(Step step) {
                        listener.onResponse(null);
                    }

                    public void onFailure(Exception e) {
                        listener.onResponse(null);
                    }
                });
                return;
            }
            listener.onResponse((Object)shardStats);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkTimeOut(StepContext stepContext, int numShardsNotOnNode, int numShardsNotInSync, String nodeToMoveOnto, ActionListener<Step> listener) {
        long timeOutInSeconds;
        ManagedIndexMetaData managedIndexMetadata = stepContext.getMetadata();
        String indexName = managedIndexMetadata.getIndex();
        Duration timeSinceActionStarted = Duration.between(StepUtils.getActionStartTime(managedIndexMetadata), Instant.now());
        long l = timeOutInSeconds = this.action.getConfigTimeout() != null && this.action.getConfigTimeout().getTimeout() != null ? this.action.getConfigTimeout().getTimeout().getSeconds() : 43200L;
        if (timeSinceActionStarted.toSeconds() > timeOutInSeconds) {
            String timeoutFailure = WaitForMoveShardsStep.getTimeoutFailure(nodeToMoveOnto);
            String loggedError = WaitForMoveShardsStep.getLoggedTimeoutError(indexName, numShardsNotOnNode, numShardsNotInSync);
            this.cleanupAndFail(timeoutFailure, loggedError, null, null, listener);
        } else {
            this.logger.debug("Shrink action move shards step running on [{}], [{}] shards need to be moved, [{}] shards need an in sync replica.", (Object)indexName, (Object)numShardsNotOnNode, (Object)numShardsNotInSync);
            HashMap<String, String> delayInfo = new HashMap<String, String>();
            delayInfo.put("message", WaitForMoveShardsStep.getTimeoutDelay(nodeToMoveOnto));
            this.info = delayInfo;
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            listener.onResponse((Object)this);
        }
    }

    public boolean isIdempotent() {
        return true;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(currentMetadata.getActionMetaData() != null ? new ActionMetaData.Builder(currentMetadata.getActionMetaData()).actionProperties(new ActionProperties(null, null, null, null, this.shrinkActionProperties, null)).build() : null).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public static String getSuccessMessage(String node) {
        return "The shards successfully moved to " + node + ".";
    }

    public static String getTimeoutFailure(String node) {
        return "Shrink failed because it took too long to move shards to " + node;
    }

    public static String getTimeoutDelay(String node) {
        return "Shrink delayed because it took too long to move shards to " + node;
    }

    public static String getLoggedTimeoutError(String index, int numShardsNotOnNode, int numShardsNotInSync) {
        return "Shrink Action move shards failed on [" + index + "], the action timed out with [" + numShardsNotOnNode + "] shards not yet moved and [" + numShardsNotInSync + "] shards without an in sync replica.";
    }
}

