/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.shrink;

import io.lucenia.indexmanagement.indexstatemanagement.action.ShrinkAction;
import io.lucenia.indexmanagement.indexstatemanagement.step.shrink.ShrinkStep;
import io.lucenia.indexmanagement.indexstatemanagement.util.StepUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.ShrinkActionProperties;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WaitForShrinkStep
extends ShrinkStep {
    public static final String name = "wait_for_shrink_step";
    public static final String SUCCESS_MESSAGE = "Shrink finished successfully.";
    public static final String GENERIC_FAILURE_MESSAGE = "Shrink failed while waiting for shards to start.";
    private final ShrinkAction action;

    public WaitForShrinkStep(ShrinkAction action) {
        super(name, true, true, true);
        this.action = action;
    }

    @Override
    protected String getGenericFailureMessage() {
        return GENERIC_FAILURE_MESSAGE;
    }

    @Override
    protected void wrappedExecute(StepContext context, ActionListener<Step> listener) {
        String indexName = context.getMetadata().getIndex();
        this.checkShrinkActionPropertiesAndRenewLock(context, (ActionListener<ShrinkActionProperties>)ActionListener.wrap(localShrinkActionProperties -> {
            if (localShrinkActionProperties == null) {
                listener.onResponse((Object)this);
                return;
            }
            String targetIndex = localShrinkActionProperties.getTargetIndexName();
            this.shrinkNotDone(targetIndex, localShrinkActionProperties.getTargetNumShards(), context.getClient(), context, (ActionListener<Boolean>)ActionListener.wrap(notDone -> {
                if (notDone.booleanValue()) {
                    this.checkTimeOut(context, targetIndex, listener);
                    return;
                }
                this.clearAllocationSettings(context, targetIndex, (ActionListener<Boolean>)ActionListener.wrap(clearedAllocation -> {
                    if (!clearedAllocation.booleanValue()) {
                        listener.onResponse((Object)this);
                        return;
                    }
                    StepUtils.resetReadOnlyAndRouting(indexName, context.getClient(), localShrinkActionProperties.getOriginalIndexSettings(), (ActionListener<Boolean>)ActionListener.wrap(resetSuccess -> {
                        if (!resetSuccess.booleanValue()) {
                            listener.onResponse((Object)this);
                            return;
                        }
                        StepUtils.deleteShrinkLock(localShrinkActionProperties, context.getLockService(), this.logger, (ActionListener<Boolean>)ActionListener.wrap(deleted -> {
                            if (!deleted.booleanValue()) {
                                this.logger.error("Failed to delete Shrink action lock on node [{}]", (Object)localShrinkActionProperties.getNodeName());
                            }
                            this.switchAliases(context, (ShrinkActionProperties)localShrinkActionProperties, (ActionListener<Boolean>)ActionListener.wrap(switchSuccess -> {
                                if (switchSuccess.booleanValue()) {
                                    this.stepStatus = Step.StepStatus.COMPLETED;
                                    HashMap<String, String> successInfo = new HashMap<String, String>();
                                    successInfo.put("message", SUCCESS_MESSAGE);
                                    this.info = successInfo;
                                } else {
                                    this.stepStatus = Step.StepStatus.FAILED;
                                    HashMap<String, String> failureInfo = new HashMap<String, String>();
                                    failureInfo.put("message", "Shrink failed due to aliases switch failure.");
                                    this.info = failureInfo;
                                }
                                listener.onResponse((Object)this);
                            }, e -> {
                                this.logger.error("Failed to switch aliases", (Throwable)e);
                                listener.onFailure(e);
                            }));
                        }, e -> {
                            this.logger.error("Failed to delete shrink lock", (Throwable)e);
                            this.switchAliases(context, (ShrinkActionProperties)localShrinkActionProperties, (ActionListener<Boolean>)ActionListener.wrap(switchSuccess -> {
                                if (switchSuccess.booleanValue()) {
                                    this.stepStatus = Step.StepStatus.COMPLETED;
                                    HashMap<String, String> successInfo = new HashMap<String, String>();
                                    successInfo.put("message", SUCCESS_MESSAGE);
                                    this.info = successInfo;
                                } else {
                                    this.stepStatus = Step.StepStatus.FAILED;
                                    HashMap<String, String> failureInfo = new HashMap<String, String>();
                                    failureInfo.put("message", "Shrink failed due to aliases switch failure.");
                                    this.info = failureInfo;
                                }
                                listener.onResponse((Object)this);
                            }, ex -> {
                                this.logger.error("Failed to switch aliases", (Throwable)ex);
                                listener.onFailure(ex);
                            }));
                        }));
                    }, e -> {
                        this.logger.error("Failed to reset read only and routing", (Throwable)e);
                        listener.onFailure(e);
                    }));
                }, e -> {
                    this.logger.error("Failed to clear allocation settings", (Throwable)e);
                    listener.onFailure(e);
                }));
            }, e -> {
                this.logger.error("Failed to check if shrink is done", (Throwable)e);
                listener.onFailure(e);
            }));
        }, e -> {
            this.logger.error("Failed to check shrink action properties and renew lock", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void shrinkNotDone(String targetIndex, int targetNumShards, Client client, StepContext context, ActionListener<Boolean> listener) {
        this.getNumPrimaryShardsStarted(client, targetIndex, (ActionListener<Integer>)ActionListener.wrap(numPrimaryShardsStarted -> {
            Integer numPrimaryShards = context.getClusterService().state().metadata().indices().get(targetIndex) != null ? Integer.valueOf(((IndexMetadata)context.getClusterService().state().metadata().indices().get(targetIndex)).getNumberOfShards()) : null;
            boolean notDone = numPrimaryShards != targetNumShards || numPrimaryShardsStarted != targetNumShards;
            listener.onResponse((Object)notDone);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void clearAllocationSettings(StepContext context, String index, final ActionListener<Boolean> listener) {
        Settings allocationSettings = Settings.builder().putNull("index.routing.allocation.require._name").build();
        StepUtils.issueUpdateSettingsRequest(context.getClient(), index, allocationSettings, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                this.cleanupAndFail(WaitForShrinkStep.getFailureMessage(index), "Shrink action to clear the allocation settings on index [" + index + "] following shrinking.", null, null, new ActionListener<Step>(){

                    public void onResponse(Step step) {
                        listener.onResponse((Object)false);
                    }

                    public void onFailure(Exception e) {
                        listener.onResponse((Object)false);
                    }
                });
                return;
            }
            listener.onResponse((Object)true);
        }, e -> {
            this.logger.error("Failed to clear allocation settings", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void getNumPrimaryShardsStarted(Client client, String targetIndex, ActionListener<Integer> listener) {
        IndicesStatsRequest targetIndexStatsRequests = (IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{targetIndex});
        client.admin().indices().stats(targetIndexStatsRequests, ActionListener.wrap(targetStatsResponse -> {
            int count = 0;
            if (targetStatsResponse.getShards() != null) {
                for (int i = 0; i < targetStatsResponse.getShards().length; ++i) {
                    if (!targetStatsResponse.getShards()[i].getShardRouting().started() || !targetStatsResponse.getShards()[i].getShardRouting().primary()) continue;
                    ++count;
                }
            }
            listener.onResponse((Object)count);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkTimeOut(StepContext stepContext, String targetIndex, ActionListener<Step> listener) {
        long timeOutInSeconds;
        ManagedIndexMetaData managedIndexMetadata = stepContext.getMetadata();
        Duration timeFromActionStarted = Duration.between(StepUtils.getActionStartTime(managedIndexMetadata), Instant.now());
        long l = timeOutInSeconds = this.action.getConfigTimeout() != null && this.action.getConfigTimeout().getTimeout() != null ? this.action.getConfigTimeout().getTimeout().getSeconds() : 43200L;
        if (timeFromActionStarted.toSeconds() > timeOutInSeconds) {
            String timeoutFailure = WaitForShrinkStep.getTimeoutFailure(targetIndex);
            this.cleanupAndFail(timeoutFailure, timeoutFailure, null, null, listener);
        } else {
            HashMap<String, String> delayInfo = new HashMap<String, String>();
            delayInfo.put("message", WaitForShrinkStep.getDelayedMessage(targetIndex));
            this.info = delayInfo;
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            listener.onResponse((Object)this);
        }
    }

    void switchAliases(StepContext context, ShrinkActionProperties shrinkActionProperties, ActionListener<Boolean> listener) {
        String sourceIndexName = context.getMetadata().getIndex();
        String targetIndexName = shrinkActionProperties.getTargetIndexName();
        if (!this.action.getSwitchAliases()) {
            this.logger.info("Switch aliases disabled from [{}] to [{}].", (Object)sourceIndexName, (Object)targetIndexName);
            listener.onResponse((Object)true);
            return;
        }
        this.logger.info("Switching aliases from [{}] to [{}].", (Object)sourceIndexName, (Object)targetIndexName);
        Set targetIndexAliasesNames = context.getClusterService().state().metadata().index(targetIndexName).getAliases().keySet();
        Map sourceIndexAliases = context.getClusterService().state().metadata().index(sourceIndexName).getAliases();
        IndicesAliasesRequest req = new IndicesAliasesRequest();
        for (String aliasName : sourceIndexAliases.keySet()) {
            req.addAliasAction(IndicesAliasesRequest.AliasActions.remove().index(sourceIndexName).alias(aliasName));
        }
        for (AliasMetadata aliasMetadata : sourceIndexAliases.values()) {
            if (targetIndexAliasesNames.contains(aliasMetadata.alias())) continue;
            IndicesAliasesRequest.AliasActions addAction = IndicesAliasesRequest.AliasActions.add().index(targetIndexName).alias(aliasMetadata.alias());
            if (aliasMetadata.filter() != null) {
                addAction.filter(aliasMetadata.filter().string());
            }
            if (aliasMetadata.indexRouting() != null) {
                addAction.routing(aliasMetadata.indexRouting());
            }
            if (aliasMetadata.searchRouting() != null) {
                addAction.searchRouting(aliasMetadata.searchRouting());
            }
            if (aliasMetadata.isHidden() != null) {
                addAction.isHidden(aliasMetadata.isHidden());
            }
            if (aliasMetadata.writeIndex() != null) {
                addAction.writeIndex(aliasMetadata.writeIndex());
            }
            req.addAliasAction(addAction);
        }
        context.getClient().admin().indices().aliases(req, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.logger.info("Aliases switched successfully from [{}] to [{}].", (Object)sourceIndexName, (Object)targetIndexName);
                listener.onResponse((Object)true);
            } else {
                this.logger.error("Switching aliases from [{}] to [{}] failed.", (Object)sourceIndexName, (Object)targetIndexName);
                listener.onResponse((Object)false);
            }
        }, e -> {
            this.logger.error("Switching aliases from [" + sourceIndexName + "] to [" + targetIndexName + "] failed due to exception.", (Throwable)e);
            listener.onResponse((Object)false);
        }));
    }

    public boolean isIdempotent() {
        return true;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(currentMetadata.getActionMetaData() != null ? new ActionMetaData.Builder(currentMetadata.getActionMetaData()).actionProperties(new ActionProperties(null, null, null, null, this.shrinkActionProperties, null)).build() : null).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public static String getDelayedMessage(String newIndex) {
        return "Shrink delayed because " + newIndex + " shards not in started state.";
    }

    public static String getFailureMessage(String newIndex) {
        return "Shrink failed while waiting for " + newIndex + " shards to start.";
    }

    public static String getTimeoutFailure(String newIndex) {
        return "Shrink failed because it timed out while waiting for " + newIndex + " shrink to finish.";
    }
}

