/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.snapshot;

import io.lucenia.indexmanagement.indexstatemanagement.action.SnapshotAction;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import io.skylite.core.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.ScriptType;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.snapshots.ConcurrentSnapshotExecutionException;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptSnapshotStep
extends Step {
    private final SnapshotAction action;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    private String snapshotName = null;
    public static final Set<String> validTopContextFields = Set.of("index", "indexUuid");
    public static final String name = "attempt_snapshot";

    public AttemptSnapshotStep(SnapshotAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        String indexName = context.getMetadata().getIndex();
        ManagedIndexMetaData managedIndexMetadata = context.getMetadata();
        ScriptService scriptService = context.getScriptService();
        List denyList = (List)context.getClusterService().getClusterSettings().get(ManagedIndexSettings.SNAPSHOT_DENY_LIST);
        String repository = this.action.getRepository();
        String snapshot = this.action.getSnapshot();
        try {
            HashMap<String, String> mutableInfo = new HashMap<String, String>();
            if (this.isDenied(denyList, repository)) {
                this.stepStatus = Step.StepStatus.FAILED;
                mutableInfo.put("message", AttemptSnapshotStep.getBlockedMessage(denyList, repository, indexName));
                this.info = new HashMap<String, Object>(mutableInfo);
                future.complete(this);
                return future;
            }
            String snapshotNameSuffix = "-" + LocalDateTime.now(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern("uuuu.MM.dd-HH:mm:ss.SSS", Locale.ROOT));
            Script snapshotScript = new Script(ScriptType.INLINE, "mustache", snapshot, Map.of());
            String defaultSnapshotName = snapshot.isBlank() ? snapshot : indexName;
            this.snapshotName = this.compileTemplate(snapshotScript, managedIndexMetadata, defaultSnapshotName, scriptService) + snapshotNameSuffix;
            CreateSnapshotRequest createSnapshotRequest = new CreateSnapshotRequest().userMetadata(Map.of("snapshot_created", "Open Distro for Elasticsearch Index Management")).indices(new String[]{indexName}).includeGlobalState(false).snapshot(this.snapshotName).repository(repository).waitForCompletion(false);
            context.getClient().admin().cluster().createSnapshot(createSnapshotRequest, ActionListener.wrap(response -> {
                this.handleSnapshotResponse((CreateSnapshotResponse)response, indexName, (Map<String, String>)mutableInfo);
                future.complete(this);
            }, e -> {
                if (e instanceof RemoteTransportException) {
                    Exception cause = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof ConcurrentSnapshotExecutionException) {
                        this.handleSnapshotException(indexName, (ConcurrentSnapshotExecutionException)cause);
                    } else {
                        this.handleException(indexName, cause);
                    }
                } else if (e instanceof ConcurrentSnapshotExecutionException) {
                    this.handleSnapshotException(indexName, (ConcurrentSnapshotExecutionException)e);
                } else {
                    this.handleException(indexName, (Exception)e);
                }
                future.complete(this);
            }));
        }
        catch (Exception e2) {
            this.handleException(indexName, e2);
            future.complete(this);
            return future;
        }
        return future;
    }

    private void handleSnapshotResponse(CreateSnapshotResponse response, String indexName, Map<String, String> mutableInfo) {
        if (response.status() == RestStatus.ACCEPTED || response.status() == RestStatus.OK) {
            this.stepStatus = Step.StepStatus.COMPLETED;
            mutableInfo.put("message", AttemptSnapshotStep.getSuccessMessage(indexName));
        } else {
            String message = AttemptSnapshotStep.getFailedMessage(indexName);
            this.logger.warn(message + " - " + String.valueOf(response));
            this.stepStatus = Step.StepStatus.FAILED;
            mutableInfo.put("message", AttemptSnapshotStep.getFailedMessage(indexName));
            mutableInfo.put("cause", response.toString());
        }
        this.info = new HashMap<String, String>(mutableInfo);
    }

    private boolean isDenied(List<String> denyList, String repoName) {
        return denyList.stream().anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)repoName));
    }

    private void handleSnapshotException(String indexName, ConcurrentSnapshotExecutionException e) {
        String message = AttemptSnapshotStep.getFailedConcurrentSnapshotMessage(indexName);
        this.logger.debug(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
        this.info = Map.of("message", message);
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptSnapshotStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = mutableInfo;
    }

    private String compileTemplate(Script template, ManagedIndexMetaData managedIndexMetaData, String defaultValue, ScriptService scriptService) {
        try {
            Map<String, Object> contextMap = LuceniaExtensions.convertToMap((ToXContent)managedIndexMetaData);
            HashMap<String, Object> filteredContext = new HashMap<String, Object>();
            for (String key : validTopContextFields) {
                if (!contextMap.containsKey(key)) continue;
                filteredContext.put(key, contextMap.get(key));
            }
            HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>(template.getParams());
            params.put("ctx", filteredContext);
            String compiledValue = ((TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT)).newInstance(params).execute();
            return compiledValue.isBlank() ? defaultValue : compiledValue;
        }
        catch (Exception e) {
            this.logger.error("Failed to compile template", (Throwable)e);
            return defaultValue;
        }
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData = currentMetadata.getActionMetaData();
        ActionMetaData updatedActionMetaData = currentActionMetaData != null ? new ActionMetaData.Builder(currentActionMetaData).actionProperties(new ActionProperties(null, this.snapshotName, null, null, null, null)).build() : null;
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(updatedActionMetaData).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return false;
    }

    public static String getBlockedMessage(List<String> denyList, String repoName, String index) {
        return "Snapshot repository [" + repoName + "] is blocked in " + String.valueOf(denyList) + " [index=" + index + "]";
    }

    public static String getFailedMessage(String index) {
        return "Failed to create snapshot [index=" + index + "]";
    }

    public static String getFailedConcurrentSnapshotMessage(String index) {
        return "Concurrent snapshot in progress, retrying next execution [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully started snapshot [index=" + index + "]";
    }
}

