/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.snapshot;

import io.lucenia.indexmanagement.indexstatemanagement.action.SnapshotAction;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotState;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaitForSnapshotStep
extends Step {
    private final SnapshotAction action;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "wait_for_snapshot";

    public WaitForSnapshotStep(SnapshotAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        String indexName = context.getMetadata().getIndex();
        ManagedIndexMetaData managedIndexMetadata = context.getMetadata();
        String repository = this.action.getRepository();
        try {
            String snapshotName = this.getSnapshotName(managedIndexMetadata, indexName);
            if (snapshotName == null) {
                future.complete(this);
                return future;
            }
            GetSnapshotsRequest newRequest = new GetSnapshotsRequest().snapshots(new String[]{snapshotName}).repository(repository);
            context.getClient().admin().cluster().getSnapshots(newRequest, ActionListener.wrap(response -> {
                this.handleSnapshotResponse((GetSnapshotsResponse)response, snapshotName, indexName);
                future.complete(this);
            }, e -> {
                if (e instanceof RemoteTransportException) {
                    this.handleException(indexName, (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                } else {
                    this.handleException(indexName, (Exception)e);
                }
                future.complete(this);
            }));
        }
        catch (Exception e2) {
            this.handleException(indexName, e2);
            future.complete(this);
        }
        return future;
    }

    private void handleSnapshotResponse(GetSnapshotsResponse response, String snapshotName, String indexName) {
        SnapshotInfo status = response.getSnapshots().stream().filter(snapshotInfo -> snapshotInfo.snapshotId().getName().equals(snapshotName)).findFirst().orElse(null);
        if (status != null) {
            if (status.state() == SnapshotState.IN_PROGRESS) {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                HashMap<String, Object> newInfo = new HashMap<String, Object>();
                newInfo.put("message", WaitForSnapshotStep.getSnapshotInProgressMessage(indexName));
                newInfo.put("state", status.state().toString());
                this.info = newInfo;
            } else if (status.state() == SnapshotState.SUCCESS) {
                this.stepStatus = Step.StepStatus.COMPLETED;
                HashMap<String, Object> newInfo = new HashMap<String, Object>();
                newInfo.put("message", WaitForSnapshotStep.getSuccessMessage(indexName));
                newInfo.put("state", status.state().toString());
                this.info = newInfo;
            } else {
                String message = WaitForSnapshotStep.getFailedExistsMessage(indexName);
                this.logger.warn(message);
                this.stepStatus = Step.StepStatus.FAILED;
                HashMap<String, Object> newInfo = new HashMap<String, Object>();
                newInfo.put("message", message);
                newInfo.put("state", status.state().toString());
                this.info = newInfo;
            }
        } else {
            String message = WaitForSnapshotStep.getFailedExistsMessage(indexName);
            this.logger.warn(message);
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", message);
        }
    }

    private void handleException(String indexName, Exception e) {
        String message = WaitForSnapshotStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = mutableInfo;
    }

    private String getSnapshotName(ManagedIndexMetaData managedIndexMetadata, String indexName) {
        ActionProperties actionProperties;
        ActionProperties actionProperties2 = actionProperties = managedIndexMetadata.getActionMetaData() != null ? managedIndexMetadata.getActionMetaData().getActionProperties() : null;
        if (actionProperties == null || actionProperties.getSnapshotName() == null) {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", WaitForSnapshotStep.getFailedActionPropertiesMessage(indexName, actionProperties));
            return null;
        }
        return actionProperties.getSnapshotName();
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(currentMetadata.getActionMetaData()).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String index) {
        return "Failed to get status of snapshot [index=" + index + "]";
    }

    public static String getFailedExistsMessage(String index) {
        return "Snapshot doesn't exist [index=" + index + "]";
    }

    public static String getFailedActionPropertiesMessage(String index, ActionProperties actionProperties) {
        return "Unable to retrieve [" + ActionProperties.Properties.SNAPSHOT_NAME.getKey() + "] from ActionProperties=" + String.valueOf(actionProperties) + " [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully created snapshot [index=" + index + "]";
    }

    public static String getSnapshotInProgressMessage(String index) {
        return "Snapshot currently in progress [index=" + index + "]";
    }
}

