/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.stopreplication;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.replication.ReplicationPluginInterface;
import io.skylite.core.replication.action.StopIndexReplicationRequest;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.snapshots.SnapshotInProgressException;

public class AttemptStopReplicationStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "attempt_stop_replication";

    public AttemptStopReplicationStep() {
        super(name);
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        if (this.getContext() == null) {
            future.complete(this);
            return future;
        }
        String indexName = this.getContext().getMetadata().getIndex();
        StopIndexReplicationRequest stopIndexReplicationRequest = new StopIndexReplicationRequest(indexName);
        try {
            ReplicationPluginInterface.stopReplication((Client)this.getContext().getClient(), (StopIndexReplicationRequest)stopIndexReplicationRequest, (ActionListener)ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = Map.of("message", AttemptStopReplicationStep.getSuccessMessage(indexName));
                } else {
                    String message = AttemptStopReplicationStep.getFailedMessage(indexName);
                    this.logger.warn(message);
                    this.stepStatus = Step.StepStatus.FAILED;
                    this.info = Map.of("message", message);
                }
                future.complete(this);
            }, e -> {
                Throwable cause = e;
                if (e instanceof RemoteTransportException) {
                    cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e);
                }
                if (cause instanceof SnapshotInProgressException) {
                    this.handleSnapshotException(indexName, (SnapshotInProgressException)cause);
                } else {
                    this.handleException(indexName, (Exception)cause);
                }
                future.complete(this);
            }));
        }
        catch (Exception e2) {
            this.handleException(indexName, e2);
            future.complete(this);
        }
        return future;
    }

    private void handleSnapshotException(String indexName, SnapshotInProgressException e) {
        String message = AttemptStopReplicationStep.getSnapshotMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        this.info = Map.of("message", message);
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptStopReplicationStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null && errorMessage.contains("failed to find action")) {
            mutableInfo.put("cause", "No replication in progress for index:" + indexName);
        } else if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = Map.copyOf(mutableInfo);
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return false;
    }

    public static String getFailedMessage(String index) {
        return "Failed to stop replication [index=" + index + "]";
    }

    public static String getSuccessMessage(String index) {
        return "Successfully stopped replication [index=" + index + "]";
    }

    public static String getSnapshotMessage(String index) {
        return "Index had snapshot in progress, retrying stop replication [index=" + index + "]";
    }
}

